/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;
import java.net.Proxy;

public final class RequestLine {
    private RequestLine() {
    }

    /*
     * Enabled aggressive block sorting
     */
    static String get(Request request, Proxy.Type type) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(request.method());
        stringBuilder.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, type)) {
            stringBuilder.append(request.httpUrl());
        } else {
            stringBuilder.append(RequestLine.requestPath(request.httpUrl()));
        }
        stringBuilder.append(" HTTP/1.1");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type type) {
        if (request.isHttps()) return false;
        if (type != Proxy.Type.HTTP) return false;
        return true;
    }

    public static String requestPath(HttpUrl object) {
        String string2 = ((HttpUrl)object).encodedPath();
        String string3 = ((HttpUrl)object).encodedQuery();
        object = string2;
        if (string3 != null) {
            object = string2 + '?' + string3;
        }
        return object;
    }
}

