/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.tls;

import com.squareup.okhttp.internal.tls.DistinguishedNameParser;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class OkHostnameVerifier
implements HostnameVerifier {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    private OkHostnameVerifier() {
    }

    public static List<String> allSubjectAltNames(X509Certificate object) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 7);
        object = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + object.size());
        arrayList.addAll(list);
        arrayList.addAll((Collection<String>)object);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getSubjectAltNames(X509Certificate arrayList, int n2) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            arrayList = ((X509Certificate)((Object)arrayList)).getSubjectAlternativeNames();
            if (arrayList == null) {
                return Collections.emptyList();
            }
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                Object object;
                List list = (List)arrayList.next();
                if (list == null || list.size() < 2 || (object = (Integer)list.get(0)) == null || (Integer)object != n2 || (object = (String)list.get(1)) == null) continue;
                arrayList2.add(object);
            }
            return arrayList2;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    static boolean verifyAsIpAddress(String string2) {
        return VERIFY_AS_IP_ADDRESS.matcher(string2).matches();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyHostName(String string2, String string3) {
        boolean bl;
        boolean bl2 = bl = false;
        if (string2 == null) return bl2;
        bl2 = bl;
        if (string2.length() == 0) return bl2;
        bl2 = bl;
        if (string2.startsWith(".")) return bl2;
        if (string2.endsWith("..")) {
            return bl;
        }
        bl2 = bl;
        if (string3 == null) return bl2;
        bl2 = bl;
        if (string3.length() == 0) return bl2;
        bl2 = bl;
        if (string3.startsWith(".")) return bl2;
        bl2 = bl;
        if (string3.endsWith("..")) return bl2;
        String string4 = string2;
        if (!string2.endsWith(".")) {
            string4 = string2 + '.';
        }
        string2 = string3;
        if (!string3.endsWith(".")) {
            string2 = string3 + '.';
        }
        if (!(string2 = string2.toLowerCase(Locale.US)).contains("*")) {
            return string4.equals(string2);
        }
        bl2 = bl;
        if (!string2.startsWith("*.")) return bl2;
        bl2 = bl;
        if (string2.indexOf(42, 1) != -1) return bl2;
        bl2 = bl;
        if (string4.length() < string2.length()) return bl2;
        bl2 = bl;
        if ("*.".equals(string2)) return bl2;
        string2 = string2.substring(1);
        bl2 = bl;
        if (!string4.endsWith(string2)) return bl2;
        int n2 = string4.length() - string2.length();
        if (n2 <= 0) return true;
        bl2 = bl;
        if (string4.lastIndexOf(46, n2 - 1) != -1) return bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyHostName(String string2, X509Certificate object) {
        string2 = string2.toLowerCase(Locale.US);
        List<String> list = OkHostnameVerifier.getSubjectAltNames((X509Certificate)object, 2);
        int n2 = list.size();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.verifyHostName(string2, list.get(i2))) {
                return true;
            }
            bl = true;
        }
        if (bl) return false;
        if ((object = new DistinguishedNameParser(((X509Certificate)object).getSubjectX500Principal()).findMostSpecific("cn")) == null) return false;
        return this.verifyHostName(string2, (String)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyIpAddress(String string2, X509Certificate list) {
        list = OkHostnameVerifier.getSubjectAltNames(list, 7);
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            if (string2.equalsIgnoreCase(list.get(n3))) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String string2, X509Certificate x509Certificate) {
        if (!OkHostnameVerifier.verifyAsIpAddress(string2)) return this.verifyHostName(string2, x509Certificate);
        return this.verifyIpAddress(string2, x509Certificate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verify(String string2, SSLSession sSLSession) {
        try {
            return this.verify(string2, (X509Certificate)sSLSession.getPeerCertificates()[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }
}

