/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class AssetBitmapHunter
extends BitmapHunter {
    protected static final String ANDROID_ASSET = "android_asset";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private AssetManager assetManager;

    public AssetBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.assetManager = context.getAssets();
    }

    @Override
    Bitmap decode(Request request) throws IOException {
        return this.decodeAsset(request.uri.toString().substring(ASSET_PREFIX_LENGTH));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Bitmap decodeAsset(String object) throws IOException {
        InputStream inputStream = null;
        BitmapFactory.Options options = AssetBitmapHunter.createBitmapOptions(this.data);
        if (this.data.hasSize()) {
            InputStream inputStream2;
            options.inJustDecodeBounds = true;
            try {
                inputStream = inputStream2 = this.assetManager.open((String)object);
                BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)options);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(inputStream);
                throw throwable;
            }
            Utils.closeQuietly(inputStream2);
            AssetBitmapHunter.calculateInSampleSize(this.data.targetWidth, this.data.targetHeight, options);
        }
        object = this.assetManager.open((String)object);
        try {
            inputStream = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options);
            return inputStream;
        }
        finally {
            Utils.closeQuietly((InputStream)object);
        }
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.b;
    }
}

