/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.NetworkInfo;
import android.net.Uri;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.AssetBitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContactsPhotoBitmapHunter;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.FileBitmapHunter;
import com.squareup.picasso.MediaStoreBitmapHunter;
import com.squareup.picasso.NetworkBitmapHunter;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.ResourceBitmapHunter;
import com.squareup.picasso.Stats;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Transformation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

abstract class BitmapHunter
implements Runnable {
    private static final Object DECODE_LOCK = new Object();
    final List<Action> actions;
    final Cache cache;
    final Request data;
    final Dispatcher dispatcher;
    Exception exception;
    int exifRotation;
    Future<?> future;
    final String key;
    Picasso.LoadedFrom loadedFrom;
    final Picasso picasso;
    Bitmap result;
    final boolean skipMemoryCache;
    final Stats stats;

    BitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        this.picasso = picasso;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.stats = stats;
        this.key = action.getKey();
        this.data = action.getData();
        this.skipMemoryCache = action.skipCache;
        this.actions = new ArrayList<Action>(4);
        this.attach(action);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Bitmap applyCustomTransformations(List<Transformation> object, Bitmap object2) {
        int n2 = object.size();
        int n3 = 0;
        while (n3 < n2) {
            final Transformation transformation = (Transformation)object.get(n3);
            Bitmap bitmap = transformation.transform((Bitmap)object2);
            if (bitmap == null) {
                object2 = new StringBuilder().append("Transformation ").append(transformation.key()).append(" returned null after ").append(n3).append(" previous transformation(s).\n\nTransformation list:\n");
                object = object.iterator();
                while (object.hasNext()) {
                    ((StringBuilder)object2).append(((Transformation)object.next()).key()).append('\n');
                }
                Picasso.HANDLER.post(new Runnable((StringBuilder)object2){
                    final /* synthetic */ StringBuilder val$builder;
                    {
                        this.val$builder = stringBuilder;
                    }

                    @Override
                    public void run() {
                        throw new NullPointerException(this.val$builder.toString());
                    }
                });
                return null;
            }
            if (bitmap == object2 && object2.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " returned input Bitmap but recycled it.");
                    }
                });
                return null;
            }
            if (bitmap != object2 && !object2.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " mutated input Bitmap but failed to recycle the original.");
                    }
                });
                return null;
            }
            ++n3;
            object2 = bitmap;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void calculateInSampleSize(int n2, int n3, int n4, int n5, BitmapFactory.Options options) {
        int n6 = 1;
        if ((n5 > n3 || n4 > n2) && (n6 = Math.round((float)n5 / (float)n3)) >= (n2 = Math.round((float)n4 / (float)n2))) {
            n6 = n2;
        }
        options.inSampleSize = n6;
        options.inJustDecodeBounds = false;
    }

    static void calculateInSampleSize(int n2, int n3, BitmapFactory.Options options) {
        BitmapHunter.calculateInSampleSize(n2, n3, options.outWidth, options.outHeight, options);
    }

    static BitmapFactory.Options createBitmapOptions(Request request) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (request.config != null) {
            options.inPreferredConfig = request.config;
        }
        return options;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BitmapHunter forRequest(Context object, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        void var6_15;
        void var0_2;
        void var4_13;
        void var3_12;
        void var2_11;
        void var1_10;
        void var5_14;
        if (var5_14.getData().resourceId != 0) {
            ResourceBitmapHunter resourceBitmapHunter = new ResourceBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
            return var0_2;
        }
        Uri uri = var5_14.getData().uri;
        String string2 = uri.getScheme();
        if ("content".equals(string2)) {
            if (ContactsContract.Contacts.CONTENT_URI.getHost().equals(uri.getHost()) && !uri.getPathSegments().contains("photo")) {
                ContactsPhotoBitmapHunter contactsPhotoBitmapHunter = new ContactsPhotoBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
                return var0_2;
            }
            if ("media".equals(uri.getAuthority())) {
                MediaStoreBitmapHunter mediaStoreBitmapHunter = new MediaStoreBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
                return var0_2;
            }
            ContentStreamBitmapHunter contentStreamBitmapHunter = new ContentStreamBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
            return var0_2;
        }
        if ("file".equals(string2)) {
            if (!uri.getPathSegments().isEmpty() && "android_asset".equals(uri.getPathSegments().get(0))) {
                AssetBitmapHunter assetBitmapHunter = new AssetBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
                return var0_2;
            }
            FileBitmapHunter fileBitmapHunter = new FileBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
            return var0_2;
        }
        if ("android.resource".equals(string2)) {
            ResourceBitmapHunter resourceBitmapHunter = new ResourceBitmapHunter((Context)object, (Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14);
            return var0_2;
        }
        NetworkBitmapHunter networkBitmapHunter = new NetworkBitmapHunter((Picasso)var1_10, (Dispatcher)var2_11, (Cache)var3_12, (Stats)var4_13, (Action)var5_14, (Downloader)var6_15);
        return var0_2;
    }

    /*
     * Unable to fully structure code
     */
    static Bitmap transformResult(Request var0, Bitmap var1_1, int var2_2) {
        block9: {
            block13: {
                block12: {
                    block8: {
                        block11: {
                            block10: {
                                var3_3 = 0;
                                var4_4 = var1_1.getWidth();
                                var5_5 = var1_1.getHeight();
                                var6_6 = new Matrix();
                                if (!var0.needsMatrixTransform()) break block9;
                                var7_7 = var0.targetWidth;
                                var8_8 = var0.targetHeight;
                                var9_9 = var0.rotationDegrees;
                                if (var9_9 == 0.0f) break block10;
                                if (!var0.hasRotationPivot) break block11;
                                var6_6.setRotate(var9_9, var0.rotationPivotX, var0.rotationPivotY);
                            }
lbl13:
                            // 2 sources

                            while (var0.centerCrop) {
                                var10_10 = (float)var7_7 / (float)var4_4;
                                var9_9 = (float)var8_8 / (float)var5_5;
                                if (var10_10 > var9_9) {
                                    var11_12 = var5_5;
                                    var8_8 = (int)Math.ceil(var9_9 / var10_10 * var11_12);
                                    var5_5 = (var5_5 - var8_8) / 2;
                                    var7_7 = var4_4;
                                    var4_4 = var8_8;
                                    var9_9 = var10_10;
lbl23:
                                    // 2 sources

                                    while (true) {
                                        var6_6.preScale(var9_9, var9_9);
                                        var8_8 = var7_7;
                                        var7_7 = var5_5;
                                        var5_5 = var3_3;
lbl29:
                                        // 3 sources

                                        while (true) {
                                            if (var2_2 != 0) {
                                                var6_6.preRotate((float)var2_2);
                                            }
                                            var6_6 = Bitmap.createBitmap((Bitmap)var1_1, (int)var5_5, (int)var7_7, (int)var8_8, (int)var4_4, (Matrix)var6_6, (boolean)true);
                                            var0 = var1_1;
                                            if (var6_6 != var1_1) {
                                                var1_1.recycle();
                                                var0 = var6_6;
                                            }
                                            return var0;
                                        }
                                        break;
                                    }
                                }
                                break block8;
                            }
                            break block12;
                        }
                        var6_6.setRotate(var9_9);
                        ** GOTO lbl13
                    }
                    var11_13 = var4_4;
                    var7_7 = (int)Math.ceil(var10_10 / var9_9 * var11_13);
                    var3_3 = (var4_4 - var7_7) / 2;
                    var8_8 = 0;
                    var4_4 = var5_5;
                    var5_5 = var8_8;
                    ** while (true)
                }
                if (!var0.centerInside) break block13;
                var10_11 = (float)var7_7 / (float)var4_4;
                var9_9 = (float)var8_8 / (float)var5_5;
                if (var10_11 < var9_9) {
                    var9_9 = var10_11;
                }
                var6_6.preScale(var9_9, var9_9);
                var8_8 = 0;
                var3_3 = var5_5;
                var7_7 = 0;
                var5_5 = var8_8;
                var8_8 = var4_4;
                var4_4 = var3_3;
                ** GOTO lbl29
            }
            if (var7_7 != 0 && var8_8 != 0 && (var7_7 != var4_4 || var8_8 != var5_5)) {
                var6_6.preScale((float)var7_7 / (float)var4_4, (float)var8_8 / (float)var5_5);
            }
        }
        var7_7 = 0;
        var3_3 = var5_5;
        var8_8 = 0;
        var5_5 = var7_7;
        var7_7 = var8_8;
        var8_8 = var4_4;
        var4_4 = var3_3;
        ** while (true)
    }

    void attach(Action action) {
        this.actions.add(action);
    }

    boolean cancel() {
        boolean bl;
        boolean bl2 = bl = false;
        if (this.actions.isEmpty()) {
            bl2 = bl;
            if (this.future != null) {
                bl2 = bl;
                if (this.future.cancel(false)) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    abstract Bitmap decode(Request var1) throws IOException;

    void detach(Action action) {
        this.actions.remove(action);
    }

    List<Action> getActions() {
        return this.actions;
    }

    Request getData() {
        return this.data;
    }

    Exception getException() {
        return this.exception;
    }

    String getKey() {
        return this.key;
    }

    Picasso.LoadedFrom getLoadedFrom() {
        return this.loadedFrom;
    }

    Bitmap getResult() {
        return this.result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Bitmap hunt() throws IOException {
        Bitmap bitmap;
        Bitmap bitmap2;
        if (!this.skipMemoryCache && (bitmap2 = this.cache.get(this.key)) != null) {
            this.stats.dispatchCacheHit();
            this.loadedFrom = Picasso.LoadedFrom.a;
            return bitmap2;
        }
        bitmap2 = bitmap = this.decode(this.data);
        if (bitmap == null) return bitmap2;
        this.stats.dispatchBitmapDecoded(bitmap);
        if (!this.data.needsTransformation()) {
            bitmap2 = bitmap;
            if (this.exifRotation == 0) return bitmap2;
        }
        Object object = DECODE_LOCK;
        synchronized (object) {
            Bitmap bitmap3;
            block10: {
                block9: {
                    if (this.data.needsMatrixTransform()) break block9;
                    bitmap3 = bitmap;
                    if (this.exifRotation == 0) break block10;
                }
                bitmap3 = BitmapHunter.transformResult(this.data, bitmap, this.exifRotation);
            }
            bitmap2 = bitmap3;
            if (this.data.hasCustomTransformations()) {
                bitmap2 = BitmapHunter.applyCustomTransformations(this.data.transformations, bitmap3);
            }
        }
        this.stats.dispatchBitmapTransformed(bitmap2);
        return bitmap2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isCancelled() {
        if (this.future == null) return false;
        if (!this.future.isCancelled()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Object object;
        try {
            object = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder();
            ((Thread)object).setName(stringBuilder.append("Picasso-").append(this.data.getName()).toString());
            this.result = this.hunt();
            if (this.result == null) {
                this.dispatcher.dispatchFailed(this);
                return;
            }
            this.dispatcher.dispatchComplete(this);
            return;
        }
        catch (Downloader.ResponseException responseException) {
            this.exception = responseException;
            this.dispatcher.dispatchFailed(this);
            return;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            this.dispatcher.dispatchRetry(this);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            object = new StringWriter();
            Object object2 = this.stats.createSnapshot();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            ((StatsSnapshot)object2).dump(printWriter);
            this.exception = object2 = new RuntimeException(((StringWriter)object).toString(), outOfMemoryError);
            this.dispatcher.dispatchFailed(this);
            return;
        }
        catch (Exception exception) {
            this.exception = exception;
            this.dispatcher.dispatchFailed(this);
            return;
        }
        finally {
            Thread.currentThread().setName("Picasso-Idle");
            return;
        }
    }

    protected void setExifRotation(int n2) {
        this.exifRotation = n2;
    }

    boolean shouldRetry(boolean bl, NetworkInfo networkInfo) {
        return false;
    }

    boolean shouldSkipMemoryCache() {
        return this.skipMemoryCache;
    }
}

