/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import com.squareup.picasso.Action;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import java.io.IOException;

class MediaStoreBitmapHunter
extends ContentStreamBitmapHunter {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    MediaStoreBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(context, picasso, dispatcher, cache, stats, action);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getExitOrientation(ContentResolver contentResolver, Uri uri) {
        int n2;
        block8: {
            block7: {
                contentResolver = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
                if (contentResolver == null) break block7;
                boolean bl = contentResolver.moveToFirst();
                if (bl) break block8;
            }
            if (contentResolver == null) return 0;
            contentResolver.close();
            return 0;
        }
        int n3 = n2 = contentResolver.getInt(0);
        if (contentResolver == null) return n3;
        contentResolver.close();
        return n2;
        catch (RuntimeException runtimeException) {
            return 0;
            catch (Throwable throwable) {
                void var1_4;
                block9: {
                    contentResolver = null;
                    break block9;
                    catch (Throwable throwable2) {}
                }
                if (contentResolver == null) throw var1_4;
                contentResolver.close();
                throw var1_4;
            }
            catch (RuntimeException runtimeException2) {}
            if (contentResolver == null) return 0;
            contentResolver.close();
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PicassoKind getPicassoKind(int n2, int n3) {
        if (n2 <= PicassoKind.a.e && n3 <= PicassoKind.a.f) {
            return PicassoKind.a;
        }
        if (n2 > PicassoKind.b.e) return PicassoKind.c;
        if (n3 > PicassoKind.b.f) return PicassoKind.c;
        return PicassoKind.b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    Bitmap decode(Request request) throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        this.setExifRotation(MediaStoreBitmapHunter.getExitOrientation(contentResolver, request.uri));
        if (!request.hasSize()) return super.decode(request);
        PicassoKind picassoKind = MediaStoreBitmapHunter.getPicassoKind(request.targetWidth, request.targetHeight);
        if (picassoKind == PicassoKind.c) {
            return super.decode(request);
        }
        long l2 = ContentUris.parseId((Uri)request.uri);
        BitmapFactory.Options options = MediaStoreBitmapHunter.createBitmapOptions(request);
        options.inJustDecodeBounds = true;
        MediaStoreBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, picassoKind.e, picassoKind.f, options);
        options = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)l2, (int)picassoKind.d, (BitmapFactory.Options)options);
        contentResolver = options;
        if (options != null) return contentResolver;
        return super.decode(request);
    }

    static enum PicassoKind {
        a(3, 96, 96),
        b(1, 512, 384),
        c(2, -1, -1);

        final int d;
        final int e;
        final int f;

        private PicassoKind(int n3, int n4, int n5) {
            this.d = n3;
            this.e = n4;
            this.f = n5;
        }
    }
}

