/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;

public class OkHttpDownloader
implements Downloader {
    static final String RESPONSE_SOURCE_ANDROID = "X-Android-Response-Source";
    static final String RESPONSE_SOURCE_OKHTTP = "OkHttp-Response-Source";
    private final OkHttpClient client;

    public OkHttpDownloader(Context context) {
        this(Utils.createDefaultCacheDir(context));
    }

    public OkHttpDownloader(Context context, long l2) {
        this(Utils.createDefaultCacheDir(context), l2);
    }

    public OkHttpDownloader(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    public OkHttpDownloader(File file) {
        this(file, Utils.calculateDiskCacheSize(file));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OkHttpDownloader(File file, long l2) {
        this(new OkHttpClient());
        try {
            OkHttpClient okHttpClient = this.client;
            HttpResponseCache httpResponseCache = new HttpResponseCache(file, l2);
            okHttpClient.setResponseCache((ResponseCache)httpResponseCache);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected OkHttpClient getClient() {
        return this.client;
    }

    @Override
    public Downloader.Response load(Uri object, boolean bl) throws IOException {
        int n2;
        HttpURLConnection httpURLConnection = this.openConnection((Uri)object);
        httpURLConnection.setUseCaches(true);
        if (bl) {
            httpURLConnection.setRequestProperty("Cache-Control", "only-if-cached,max-age=2147483647");
        }
        if ((n2 = httpURLConnection.getResponseCode()) >= 300) {
            httpURLConnection.disconnect();
            throw new Downloader.ResponseException(n2 + " " + httpURLConnection.getResponseMessage());
        }
        String string2 = httpURLConnection.getHeaderField(RESPONSE_SOURCE_OKHTTP);
        object = string2;
        if (string2 == null) {
            object = httpURLConnection.getHeaderField(RESPONSE_SOURCE_ANDROID);
        }
        bl = Utils.parseResponseSourceHeader((String)object);
        return new Downloader.Response(httpURLConnection.getInputStream(), bl);
    }

    protected HttpURLConnection openConnection(Uri object) throws IOException {
        object = this.client.open(new URL(object.toString()));
        ((URLConnection)object).setConnectTimeout(15000);
        ((URLConnection)object).setReadTimeout(20000);
        return object;
    }
}

