/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;

final class PicassoDrawable
extends Drawable {
    private static final Paint DEBUG_PAINT = new Paint();
    private static final float FADE_DURATION = 200.0f;
    int alpha = 255;
    boolean animating;
    private final boolean debugging;
    private final float density;
    final BitmapDrawable image;
    private final Picasso.LoadedFrom loadedFrom;
    Drawable placeholder;
    long startTimeMillis;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PicassoDrawable(Context context, Drawable drawable2, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean bl, boolean bl2) {
        context = context.getResources();
        this.debugging = bl2;
        this.density = context.getDisplayMetrics().density;
        this.loadedFrom = loadedFrom;
        this.image = new BitmapDrawable((Resources)context, bitmap);
        if (loadedFrom == Picasso.LoadedFrom.a) return;
        if (bl) return;
        boolean bl3 = true;
        if (!bl3) return;
        this.placeholder = drawable2;
        this.animating = true;
        this.startTimeMillis = SystemClock.uptimeMillis();
    }

    private void drawDebugIndicator(Canvas canvas) {
        DEBUG_PAINT.setColor(-1);
        canvas.drawPath(PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(16.0f * this.density)), DEBUG_PAINT);
        DEBUG_PAINT.setColor(this.loadedFrom.d);
        canvas.drawPath(PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(15.0f * this.density)), DEBUG_PAINT);
    }

    private static Path getTrianglePath(Point point, int n2) {
        Point point2 = new Point(point.x + n2, point.y);
        Point point3 = new Point(point.x, point.y + n2);
        Path path = new Path();
        path.moveTo((float)point.x, (float)point.y);
        path.lineTo((float)point2.x, (float)point2.y);
        path.lineTo((float)point3.x, (float)point3.y);
        return path;
    }

    static void setBitmap(ImageView imageView, Context context, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean bl, boolean bl2) {
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 instanceof AnimationDrawable) {
            ((AnimationDrawable)drawable2).stop();
        }
        imageView.setImageDrawable((Drawable)new PicassoDrawable(context, drawable2, bitmap, loadedFrom, bl, bl2));
    }

    /*
     * Enabled aggressive block sorting
     */
    static void setPlaceholder(ImageView imageView, int n2, Drawable drawable2) {
        if (n2 != 0) {
            imageView.setImageResource(n2);
        } else {
            imageView.setImageDrawable(drawable2);
        }
        if (imageView.getDrawable() instanceof AnimationDrawable) {
            ((AnimationDrawable)imageView.getDrawable()).start();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        if (!this.animating) {
            this.image.draw(canvas);
        } else {
            float f2 = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / 200.0f;
            if (f2 >= 1.0f) {
                this.animating = false;
                this.placeholder = null;
                this.image.draw(canvas);
            } else {
                if (this.placeholder != null) {
                    this.placeholder.draw(canvas);
                }
                int n2 = (int)(f2 * (float)this.alpha);
                this.image.setAlpha(n2);
                this.image.draw(canvas);
                this.image.setAlpha(this.alpha);
                this.invalidateSelf();
            }
        }
        if (this.debugging) {
            this.drawDebugIndicator(canvas);
        }
    }

    public int getIntrinsicHeight() {
        return this.image.getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return this.image.getIntrinsicWidth();
    }

    public int getOpacity() {
        return this.image.getOpacity();
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.image.setBounds(rect);
        if (this.placeholder != null) {
            this.placeholder.setBounds(rect);
        }
    }

    public void setAlpha(int n2) {
        this.alpha = n2;
        if (this.placeholder != null) {
            this.placeholder.setAlpha(n2);
        }
        this.image.setAlpha(n2);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.placeholder != null) {
            this.placeholder.setColorFilter(colorFilter);
        }
        this.image.setColorFilter(colorFilter);
    }
}

