/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class UrlConnectionDownloader
implements Downloader {
    static final String RESPONSE_SOURCE = "X-Android-Response-Source";
    static volatile Object cache;
    private static final Object lock;
    private final Context context;

    static {
        lock = new Object();
    }

    public UrlConnectionDownloader(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void installCacheIfNeeded(Context context) {
        if (cache != null) return;
        try {
            Object object = lock;
            synchronized (object) {
                if (cache != null) return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        {
            cache = ResponseCacheIcs.install(context);
            return;
        }
    }

    @Override
    public Downloader.Response load(Uri object, boolean bl) throws IOException {
        int n2;
        if (Build.VERSION.SDK_INT >= 14) {
            UrlConnectionDownloader.installCacheIfNeeded(this.context);
        }
        object = this.openConnection((Uri)object);
        ((URLConnection)object).setUseCaches(true);
        if (bl) {
            ((URLConnection)object).setRequestProperty("Cache-Control", "only-if-cached,max-age=2147483647");
        }
        if ((n2 = ((HttpURLConnection)object).getResponseCode()) >= 300) {
            ((HttpURLConnection)object).disconnect();
            throw new Downloader.ResponseException(n2 + " " + ((HttpURLConnection)object).getResponseMessage());
        }
        bl = Utils.parseResponseSourceHeader(((URLConnection)object).getHeaderField(RESPONSE_SOURCE));
        return new Downloader.Response(((URLConnection)object).getInputStream(), bl);
    }

    protected HttpURLConnection openConnection(Uri object) throws IOException {
        object = (HttpURLConnection)new URL(object.toString()).openConnection();
        ((URLConnection)object).setConnectTimeout(15000);
        ((URLConnection)object).setReadTimeout(20000);
        return object;
    }

    private static class ResponseCacheIcs {
        private ResponseCacheIcs() {
        }

        static Object install(Context context) throws IOException {
            File file = Utils.createDefaultCacheDir(context);
            HttpResponseCache httpResponseCache = HttpResponseCache.getInstalled();
            context = httpResponseCache;
            if (httpResponseCache == null) {
                context = HttpResponseCache.install((File)file, (long)Utils.calculateDiskCacheSize(file));
            }
            return context;
        }
    }
}

