/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXEmojiObject
implements WXMediaMessage.IMediaObject {
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final String TAG = "MicroMsg.SDK.WXEmojiObject";
    public byte[] emojiData;
    public String emojiPath;

    public WXEmojiObject() {
        this.emojiData = null;
        this.emojiPath = null;
    }

    public WXEmojiObject(String string2) {
        this.emojiPath = string2;
    }

    public WXEmojiObject(byte[] byArray) {
        this.emojiData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (!(this.emojiData != null && this.emojiData.length != 0 || this.emojiPath != null && this.emojiPath.length() != 0)) {
            Log.e(TAG, "checkArgs fail, both arguments is null");
            return bl;
        }
        if (this.emojiData != null && this.emojiData.length > 0xA00000) {
            Log.e(TAG, "checkArgs fail, emojiData is too large");
            return bl;
        }
        if (this.emojiPath == null) return true;
        if (this.getFileSize(this.emojiPath) <= 0xA00000) return true;
        Log.e(TAG, "checkArgs fail, emojiSize is too large");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxemojiobject_emojiData", this.emojiData);
        bundle.putString("_wxemojiobject_emojiPath", this.emojiPath);
    }

    public void setEmojiData(byte[] byArray) {
        this.emojiData = byArray;
    }

    public void setEmojiPath(String string2) {
        this.emojiPath = string2;
    }

    public int type() {
        return 8;
    }

    public void unserialize(Bundle bundle) {
        this.emojiData = bundle.getByteArray("_wxemojiobject_emojiData");
        this.emojiPath = bundle.getString("_wxemojiobject_emojiPath");
    }
}

