/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXGameVideoFileObject
implements WXMediaMessage.IMediaObject {
    private static final int FILE_SIZE_LIMIT = 0xA00000;
    private static final String TAG = "MicroMsg.SDK.WXGameVideoFileObject";
    private static final int URL_LENGTH_LIMIT = 10240;
    public String filePath;
    public String thumbUrl;
    public String videoUrl;

    public WXGameVideoFileObject() {
        this.filePath = null;
        this.videoUrl = null;
        this.thumbUrl = null;
    }

    public WXGameVideoFileObject(String string2, String string3, String string4) {
        this.filePath = string2;
        this.videoUrl = string3;
        this.thumbUrl = string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (this.filePath == null || this.filePath.length() == 0) {
            Log.e(TAG, "checkArgs fail, filePath is null");
            return bl;
        }
        if (this.getFileSize(this.filePath) > 0xA00000) {
            Log.e(TAG, "checkArgs fail, video file size is too large");
            return bl;
        }
        if (this.videoUrl != null && this.videoUrl.length() > 10240) {
            Log.e(TAG, "checkArgs fail, videoUrl is too long");
            return bl;
        }
        if (this.thumbUrl == null) return true;
        if (this.thumbUrl.length() <= 10240) return true;
        Log.e(TAG, "checkArgs fail, thumbUrl is too long");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putString("_wxvideofileobject_filePath", this.filePath);
        bundle.putString("_wxvideofileobject_cdnUrl", this.videoUrl);
        bundle.putString("_wxvideofileobject_thumbUrl", this.thumbUrl);
    }

    public int type() {
        return 39;
    }

    public void unserialize(Bundle bundle) {
        this.filePath = bundle.getString("_wxvideofileobject_filePath");
        this.videoUrl = bundle.getString("_wxvideofileobject_cdnUrl");
        this.thumbUrl = bundle.getString("_wxvideofileobject_thumbUrl");
    }
}

