/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TbsDownloadConfig {
    public static final int CMD_ID_DOWNLOAD_FILE = 101;
    public static final int CMD_ID_FILE_UPLOAD = 100;
    public static final long DEFAULT_RETRY_INTERVAL_SEC = 86400L;
    public static final int ERROR_DOWNLOAD = 2;
    public static final int ERROR_INSTALL = 5;
    public static final int ERROR_LOAD = 6;
    public static final int ERROR_NONE = 1;
    public static final int ERROR_REPORTED = 0;
    public static final int ERROR_UNZIP = 4;
    public static final int ERROR_VERIFY = 3;
    private static TbsDownloadConfig b;
    Map<String, Object> a = new HashMap<String, Object>();
    private Context c;
    public SharedPreferences mPreferences;

    private TbsDownloadConfig(Context context) {
        this.mPreferences = context.getSharedPreferences("tbs_download_config", 4);
        this.c = context.getApplicationContext();
    }

    public static TbsDownloadConfig getInstance() {
        synchronized (TbsDownloadConfig.class) {
            TbsDownloadConfig tbsDownloadConfig = b;
            return tbsDownloadConfig;
        }
    }

    public static TbsDownloadConfig getInstance(Context object) {
        synchronized (TbsDownloadConfig.class) {
            if (b == null) {
                TbsDownloadConfig tbsDownloadConfig;
                b = tbsDownloadConfig = new TbsDownloadConfig((Context)object);
            }
            object = b;
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clear() {
        try {
            this.a.clear();
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.clear();
            editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() {
        synchronized (this) {
            try {
                SharedPreferences.Editor editor = this.mPreferences.edit();
                for (String string2 : this.a.keySet()) {
                    Object object = this.a.get(string2);
                    if (object instanceof String) {
                        editor.putString(string2, (String)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        editor.putBoolean(string2, ((Boolean)object).booleanValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        editor.putLong(string2, ((Long)object).longValue());
                        continue;
                    }
                    if (object instanceof Integer) {
                        editor.putInt(string2, ((Integer)object).intValue());
                        continue;
                    }
                    if (!(object instanceof Float)) continue;
                    editor.putFloat(string2, ((Float)object).floatValue());
                }
                editor.commit();
                this.a.clear();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public int getDownloadFailedMaxRetrytimes() {
        synchronized (this) {
            int n2;
            block3: {
                int n3;
                n2 = n3 = this.mPreferences.getInt("tbs_download_failed_max_retrytimes", 0);
                if (n3 != 0) break block3;
                n2 = 100;
            }
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDownloadInterruptCode() {
        synchronized (this) {
            int n2;
            int n3;
            boolean bl;
            block15: {
                block18: {
                    block17: {
                        block16: {
                            bl = this.mPreferences.contains("tbs_download_interrupt_code");
                            if (bl) break block16;
                            try {
                                File file = new File(this.c.getFilesDir(), "shared_prefs");
                                File file2 = new File(file, "tbs_download_config");
                                bl = file2.exists();
                                if (!bl) {
                                    n3 = -97;
                                    break block15;
                                }
                                bl = this.mPreferences.contains("tbs_needdownload");
                                if (!bl) {
                                    n3 = -96;
                                    break block15;
                                }
                                n3 = -101;
                            }
                            catch (Throwable throwable) {
                                n3 = -95;
                            }
                            break block15;
                        }
                        n3 = this.mPreferences.getInt("tbs_download_interrupt_code", -99);
                        if (n3 == -119) break block17;
                        n2 = n3;
                        if (n3 != -121) break block18;
                    }
                    n2 = this.mPreferences.getInt("tbs_download_interrupt_code_reason", -119);
                }
                n3 = n2;
                if (System.currentTimeMillis() - this.mPreferences.getLong("tbs_download_interrupt_time", 0L) > 86400000L) {
                    n3 = n2 - 98000;
                }
            }
            if (this.c != null && "com.tencent.mobileqq".equals(this.c.getApplicationInfo().packageName) && !(bl = "CN".equals(Locale.getDefault().getCountry()))) {
                return -320;
            }
            n2 = this.mPreferences.getInt("tbs_install_interrupt_code", -1);
            return n3 * 1000 + n2;
        }
    }

    public long getDownloadMaxflow() {
        synchronized (this) {
            int n2;
            block3: {
                int n3;
                n2 = n3 = this.mPreferences.getInt("tbs_download_maxflow", 0);
                if (n3 != 0) break block3;
                n2 = 20;
            }
            long l2 = n2 * 1024;
            return l2 * 1024L;
        }
    }

    public long getDownloadMinFreeSpace() {
        int n2 = 0;
        synchronized (this) {
            int n3;
            block3: {
                n3 = this.mPreferences.getInt("tbs_download_min_free_space", 0);
                if (n3 != 0) break block3;
                n3 = n2;
            }
            long l2 = n3 * 1024;
            return l2 * 1024L;
        }
    }

    public long getDownloadSingleTimeout() {
        synchronized (this) {
            long l2;
            block3: {
                long l3;
                l2 = l3 = this.mPreferences.getLong("tbs_single_timeout", 0L);
                if (l3 != 0L) break block3;
                l2 = 1200000L;
            }
            return l2;
        }
    }

    public int getDownloadSuccessMaxRetrytimes() {
        synchronized (this) {
            int n2;
            block3: {
                int n3;
                n2 = n3 = this.mPreferences.getInt("tbs_download_success_max_retrytimes", 0);
                if (n3 != 0) break block3;
                n2 = 3;
            }
            return n2;
        }
    }

    public long getRetryInterval() {
        synchronized (this) {
            long l2 = this.mPreferences.getLong("retry_interval", 86400L);
            return l2;
        }
    }

    public boolean isOverSea() {
        synchronized (this) {
            boolean bl = this.mPreferences.getBoolean("is_oversea", false);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDownloadInterruptCode(int n2) {
        synchronized (this) {
            try {
                SharedPreferences.Editor editor = this.mPreferences.edit();
                editor.putInt("tbs_download_interrupt_code", n2);
                editor.putLong("tbs_download_interrupt_time", System.currentTimeMillis());
                editor.commit();
            }
            catch (Exception exception) {}
            return;
        }
    }

    public void setInstallInterruptCode(int n2) {
        synchronized (this) {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.putInt("tbs_install_interrupt_code", n2);
            editor.commit();
            return;
        }
    }

    public static interface TbsConfigKey {
        public static final String KEY_APP_METADATA = "app_metadata";
        public static final String KEY_APP_VERSIONCODE = "app_versioncode";
        public static final String KEY_APP_VERSIONCODE_FOR_SWITCH = "app_versioncode_for_switch";
        public static final String KEY_APP_VERSIONNAME = "app_versionname";
        public static final String KEY_BACKUPCORE_DELFILELIST = "backupcore_delfilelist";
        public static final String KEY_DESkEY_TOKEN = "tbs_deskey_token";
        public static final String KEY_DEVICE_CPUABI = "device_cpuabi";
        public static final String KEY_DOWNLOADURL_LIST = "tbs_downloadurl_list";
        public static final String KEY_DOWNLOAD_FAILED_MAX_RETRYTIMES = "tbs_download_failed_max_retrytimes";
        public static final String KEY_DOWNLOAD_FAILED_RETRYTIMES = "tbs_download_failed_retrytimes";
        public static final String KEY_DOWNLOAD_INTERRUPT_CODE = "tbs_download_interrupt_code";
        public static final String KEY_DOWNLOAD_INTERRUPT_CODE_REASON = "tbs_download_interrupt_code_reason";
        public static final String KEY_DOWNLOAD_INTERRUPT_TIME = "tbs_download_interrupt_time";
        public static final String KEY_DOWNLOAD_MAXFLOW = "tbs_download_maxflow";
        public static final String KEY_DOWNLOAD_MIN_FREE_SPACE = "tbs_download_min_free_space";
        public static final String KEY_DOWNLOAD_SINGLE_TIMEOUT = "tbs_single_timeout";
        public static final String KEY_DOWNLOAD_SUCCESS_MAX_RETRYTIMES = "tbs_download_success_max_retrytimes";
        public static final String KEY_DOWNLOAD_SUCCESS_RETRYTIMES = "tbs_download_success_retrytimes";
        public static final String KEY_FULL_PACKAGE = "request_full_package";
        public static final String KEY_INSTALL_INTERRUPT_CODE = "tbs_install_interrupt_code";
        public static final String KEY_IS_OVERSEA = "is_oversea";
        public static final String KEY_LAST_CHECK = "last_check";
        public static final String KEY_LAST_THIRDAPP_SENDREQUEST_COREVERSION = "last_thirdapp_sendrequest_coreversion";
        public static final String KEY_NEEDDOWNLOAD = "tbs_needdownload";
        public static final String KEY_RESPONSECODE = "tbs_responsecode";
        public static final String KEY_RETRY_INTERVAL = "retry_interval";
        public static final String KEY_STOP_PRE_OAT = "tbs_stop_preoat";
        public static final String KEY_SWITCH_BACKUPCORE_ENABLE = "switch_backupcore_enable";
        public static final String KEY_TBSAPKFILESIZE = "tbs_apkfilesize";
        public static final String KEY_TBSAPK_MD5 = "tbs_apk_md5";
        public static final String KEY_TBSDOWNLOADURL = "tbs_downloadurl";
        public static final String KEY_TBSDOWNLOAD_FLOW = "tbs_downloadflow";
        public static final String KEY_TBSDOWNLOAD_STARTTIME = "tbs_downloadstarttime";
        public static final String KEY_TBS_DOWNLOAD_V = "tbs_download_version";
        public static final String KEY_USE_BACKUP_VERSION = "use_backup_version";
    }
}

