/*
 * Decompiled with CFR 0.152.
 */
package com.wuba;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.wuba.api.filter.common.RendererUtils;

public class PhotoSimple {
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_sampler;\nvarying vec2 v_texcoord;\nvoid main() {\ngl_FragColor = texture2D(tex_sampler, v_texcoord);\n}\n";
    private static final float[] POS_VERTICES;
    private static final int TEXTUREUNSET = -20000;
    private static final float[] TEX_VERTICES;
    private static final String VERTEX_SHADER = "attribute vec4 a_position;\nattribute vec2 a_texcoord;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_Position = a_position;\n  v_texcoord = a_texcoord;\n}\n";
    private int height;
    private int texture = -20000;
    private int width;

    static {
        TEX_VERTICES = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        POS_VERTICES = new float[]{-1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f};
    }

    public PhotoSimple(int n2, int n3, int n4) {
        this.texture = n2;
        this.width = n3;
        this.height = n4;
    }

    private void copyFBO(PhotoSimple photoSimple) {
        this.width = photoSimple.width;
        this.height = photoSimple.height;
        if (this.texture != -20000) {
            RendererUtils.clearTexture(this.texture);
        }
        this.texture = RendererUtils.createTexture();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glBindTexture((int)3553, (int)0);
        RendererUtils.FilterContext filterContext = RendererUtils.createFilterProgram(VERTEX_SHADER, FRAGMENT_SHADER, POS_VERTICES, TEX_VERTICES);
        RendererUtils.renderTexture2FBO(filterContext, photoSimple.texture(), this.texture, this.width, this.height);
        RendererUtils.deleteProgram(filterContext.shaderProgram);
    }

    private void copySave(PhotoSimple photoSimple) {
        this.width = photoSimple.width;
        this.height = photoSimple.height;
        if (this.texture != -20000) {
            RendererUtils.clearTexture(this.texture);
        }
        photoSimple = photoSimple.save();
        this.texture = RendererUtils.createTexture((Bitmap)photoSimple);
        photoSimple.recycle();
    }

    public static PhotoSimple create(int n2, int n3) {
        return new PhotoSimple(RendererUtils.createTexture(), n2, n3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoSimple create(Bitmap object) {
        void var0_2;
        if (object == null) return var0_2;
        PhotoSimple photoSimple = new PhotoSimple(RendererUtils.createTexture(object), object.getWidth(), object.getHeight());
        object.recycle();
        PhotoSimple photoSimple2 = photoSimple;
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoSimple create(PhotoSimple photoSimple) {
        if (photoSimple == null) {
            return null;
        }
        PhotoSimple photoSimple2 = new PhotoSimple(-20000, photoSimple.width, photoSimple.height);
        photoSimple2.copy(photoSimple);
        return photoSimple2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoSimple createWithoutRecycle(Bitmap object) {
        void var0_2;
        if (object == null) return var0_2;
        PhotoSimple photoSimple = new PhotoSimple(RendererUtils.createTexture(object), object.getWidth(), object.getHeight());
        return var0_2;
    }

    public void changeBitmap(Bitmap bitmap) {
        this.width = bitmap.getWidth();
        this.height = bitmap.getHeight();
        RendererUtils.clearTexture(this.texture);
        this.texture = RendererUtils.createTexture(bitmap);
    }

    public void changeDimension(int n2, int n3) {
        this.width = n2;
        this.height = n3;
        RendererUtils.clearTexture(this.texture);
        this.texture = RendererUtils.createTexture();
    }

    public void clear() {
        RendererUtils.clearTexture(this.texture);
        this.texture = -20000;
    }

    public void copy(PhotoSimple photoSimple) {
        if (this.texture == photoSimple.texture()) {
            throw new IllegalArgumentException();
        }
        this.copyFBO(photoSimple);
    }

    public int height() {
        return this.height;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchDimension(PhotoSimple photoSimple) {
        if (photoSimple.width != this.width) return false;
        if (photoSimple.height != this.height) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap save() {
        Bitmap bitmap = null;
        try {
            Bitmap bitmap2 = RendererUtils.saveTexture(this.texture, this.width, this.height);
            return bitmap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            return bitmap;
        }
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setTexture(int n2) {
        this.texture = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void swap(PhotoSimple photoSimple) {
        int n2 = photoSimple.texture;
        photoSimple.texture = this.texture;
        this.texture = n2;
        n2 = photoSimple.height;
        photoSimple.height = this.height;
        this.height = n2;
        n2 = photoSimple.width;
        photoSimple.width = this.width;
        this.width = n2;
    }

    public int texture() {
        return this.texture;
    }

    public int width() {
        return this.width;
    }
}

