/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.opengl.GLES20;
import com.wuba.api.filter.common.LogUtil;
import com.wuba.api.filter.common.RendererUtils;

public class GLFrame {
    int[] fbo;
    int height;
    public GLFrame nextGLFrame;
    boolean owntexture = false;
    int[] texture = new int[]{0};
    int width;

    public GLFrame() {
        this.fbo = new int[]{0};
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bindFrame(int n2, int n3, int n4, double d2) {
        RendererUtils.checkGlError("before glBindFramebuffer");
        if (n2 == 0) {
            double d3;
            GLES20.glBindFramebuffer((int)36160, (int)0);
            if (d2 <= 0.0) {
                GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
                return;
            }
            double d4 = n4;
            double d5 = d3 = (double)n4 * d2;
            if ((double)n3 > d3) {
                d5 = n3;
                d4 = (double)n3 / d2;
            }
            GLES20.glViewport((int)((int)(-(d5 - (double)n3)) / 2), (int)((int)(-(d4 - (double)n4)) / 2), (int)((int)d5), (int)((int)d4));
            return;
        }
        if ((n2 > 0 && this.texture[0] != n2 || this.width != n3 || this.height != n4) && this.fbo[0] != 0) {
            GLES20.glBindFramebuffer((int)36160, (int)this.fbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)0, (int)0);
            if (this.owntexture && this.texture[0] != 0) {
                GLES20.glDeleteTextures((int)1, (int[])this.texture, (int)0);
                this.texture[0] = 0;
            }
        }
        this.width = n3;
        this.height = n4;
        if (this.fbo[0] <= 0) {
            GLES20.glGenFramebuffers((int)1, (int[])this.fbo, (int)0);
        }
        if (n2 > 0 && this.texture[0] != n2) {
            this.owntexture = false;
            this.texture[0] = n2;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)this.fbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture[0], (int)0);
            GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            LogUtil.d(this, "new frame buffer");
        } else if (this.texture[0] <= 0) {
            this.owntexture = true;
            GLES20.glActiveTexture((int)33984);
            GLES20.glGenTextures((int)1, (int[])this.texture, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)this.fbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture[0], (int)0);
            GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            LogUtil.d(this, "new frame buffer auto");
        } else {
            GLES20.glBindFramebuffer((int)36160, (int)this.fbo[0]);
            GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
        RendererUtils.checkGlError("glBindFramebuffer");
    }

    public void clear() {
        LogUtil.d(this, "frame clear");
        if (this.fbo[0] != 0) {
            GLES20.glBindFramebuffer((int)36160, (int)this.fbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)0, (int)0);
            GLES20.glDeleteFramebuffers((int)1, (int[])this.fbo, (int)0);
            this.fbo[0] = 0;
            if (this.owntexture) {
                GLES20.glDeleteTextures((int)1, (int[])this.texture, (int)0);
            }
            this.texture[0] = 0;
        }
        if (this.nextGLFrame != null) {
            this.nextGLFrame.clear();
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public int getTextureId() {
        return this.texture[0];
    }
}

