/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.wuba.api.filter.FilterManager;
import com.wuba.api.filter.common.BitmapSimpleUtils;
import com.wuba.api.filter.common.LogUtil;
import com.wuba.api.filter.common.RendererUtils;
import java.nio.FloatBuffer;

public abstract class GLParam {
    public int handle;
    public String name;

    public GLParam(String string2) {
        this.name = string2;
    }

    public void clear() {
    }

    public void initialParams(int n2) {
        this.handle = GLES20.glGetUniformLocation((int)n2, (String)this.name);
    }

    public abstract void setParams(int var1);

    public String toString() {
        return this.name;
    }

    public static class Float1SGLParam
    extends GLParam {
        FloatBuffer value;

        public Float1SGLParam(String string2, double[] dArray) {
            super(string2);
            this.value = FloatBuffer.allocate(dArray.length);
            this.value.position(0);
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.value.put((float)dArray[i2]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setParams(int n2) {
            if (this.handle < 0) {
                return;
            }
            GLES20.glUniform1fv((int)this.handle, (int)this.value.capacity(), (FloatBuffer)this.value);
            RendererUtils.checkGlError("FloatParam setParams");
        }

        @Override
        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    public static class Float2FGLParam
    extends GLParam {
        public float x;
        public float y;

        public Float2FGLParam(String string2, float f2, float f3) {
            super(string2);
            this.x = f2;
            this.y = f3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setParams(int n2) {
            if (this.handle < 0) {
                return;
            }
            GLES20.glUniform2f((int)this.handle, (float)this.x, (float)this.y);
            RendererUtils.checkGlError("Float2fParam setParams");
        }

        @Override
        public String toString() {
            return this.name + "=" + this.x;
        }
    }

    public static class FloatGLParam
    extends GLParam {
        float value;

        public FloatGLParam(String string2, float f2) {
            super(string2);
            this.value = f2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setParams(int n2) {
            if (this.handle < 0) {
                return;
            }
            GLES20.glUniform1f((int)this.handle, (float)this.value);
            RendererUtils.checkGlError("FloatParam setParams");
        }

        @Override
        public String toString() {
            return this.name + "=" + this.value;
        }

        public void updateParam(float f2) {
            this.value = f2;
        }

        public float value() {
            return this.value;
        }
    }

    public static class FloatsGLParam
    extends GLParam {
        float[] value;

        public FloatsGLParam(String string2, float[] fArray) {
            super(string2);
            this.value = fArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setParams(int n2) {
            if (this.handle < 0) {
                return;
            }
            switch (this.value.length) {
                case 1: {
                    GLES20.glUniform1f((int)this.handle, (float)this.value[0]);
                    break;
                }
                case 2: {
                    GLES20.glUniform2fv((int)this.handle, (int)1, (float[])this.value, (int)0);
                    break;
                }
                case 3: {
                    GLES20.glUniform3fv((int)this.handle, (int)1, (float[])this.value, (int)0);
                    break;
                }
                case 4: {
                    GLES20.glUniform4fv((int)this.handle, (int)1, (float[])this.value, (int)0);
                    break;
                }
                case 9: {
                    GLES20.glUniformMatrix3fv((int)this.handle, (int)1, (boolean)false, (float[])this.value, (int)0);
                    break;
                }
                case 16: {
                    GLES20.glUniformMatrix4fv((int)this.handle, (int)1, (boolean)false, (float[])this.value, (int)0);
                    break;
                }
            }
            RendererUtils.checkGlError("FloatsParam setParams");
        }

        @Override
        public String toString() {
            return this.name + "=" + this.value.toString();
        }
    }

    public static class IntGLParam
    extends GLParam {
        int value;

        public IntGLParam(String string2, int n2) {
            super(string2);
            this.value = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setParams(int n2) {
            if (this.handle < 0) {
                return;
            }
            GLES20.glUniform1i((int)this.handle, (int)this.value);
            RendererUtils.checkGlError("IntParam setParams");
        }

        @Override
        public String toString() {
            return this.name + "=" + this.value;
        }

        public void updateParam(int n2) {
            this.value = n2;
        }
    }

    public static class TextureBitmapGLDelayUpdateParam
    extends TextureGLParam {
        public TextureBitmapGLDelayUpdateParam(String string2, int n2) {
            super(string2, 0, n2);
        }

        @Override
        public void clear() {
            super.clear();
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glDeleteTextures((int)1, (int[])this.texture, (int)0);
            this.texture[0] = 0;
        }

        @Override
        public void initialParams(int n2) {
            super.initialParams(n2);
        }

        public void updateParam(Bitmap bitmap) {
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glGenTextures((int)1, (int[])this.texture, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
    }

    public static class TextureBitmapGLParam
    extends TextureGLParam {
        Bitmap textureBitmap;

        public TextureBitmapGLParam(String string2, Bitmap bitmap, int n2) {
            super(string2, 0, n2);
            this.textureBitmap = bitmap;
        }

        @Override
        public void clear() {
            super.clear();
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glDeleteTextures((int)1, (int[])this.texture, (int)0);
            this.texture[0] = 0;
            this.textureBitmap = null;
        }

        @Override
        public void initialParams(int n2) {
            super.initialParams(n2);
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glGenTextures((int)1, (int[])this.texture, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.textureBitmap, (int)0);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
    }

    public static class TextureGLParam
    extends GLParam {
        int[] texture = new int[]{0};
        int textureId;

        public TextureGLParam(String string2, int n2, int n3) {
            super(string2);
            this.textureId = n3;
            this.texture[0] = n2;
        }

        @Override
        public void clear() {
            super.clear();
            this.texture[0] = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setParams(int n2) {
            int n3 = 0;
            if (this.handle < 0) return;
            if (this.texture[0] == 0) {
                return;
            }
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            n2 = n3;
            switch (this.textureId) {
                default: {
                    n2 = n3;
                    break;
                }
                case 33985: {
                    n2 = 1;
                    break;
                }
                case 33986: {
                    n2 = 2;
                    break;
                }
                case 33987: {
                    n2 = 3;
                    break;
                }
                case 33988: {
                    n2 = 4;
                    break;
                }
                case 33989: {
                    n2 = 5;
                    break;
                }
                case 33990: {
                    n2 = 6;
                }
                case 33984: {
                    break;
                }
                case 33991: {
                    n2 = 7;
                }
            }
            GLES20.glUniform1i((int)this.handle, (int)n2);
            RendererUtils.checkGlError("TextureParam setParams");
        }
    }

    public static class TextureResGLParam
    extends TextureGLParam {
        int textureResId;

        public TextureResGLParam(String string2, int n2, int n3) {
            super(string2, 0, n3);
            this.textureResId = n2;
        }

        @Override
        public void clear() {
            super.clear();
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glDeleteTextures((int)1, (int[])this.texture, (int)0);
            this.texture[0] = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void initialParams(int n2) {
            super.initialParams(n2);
            if (this.textureResId <= 0) {
                return;
            }
            GLES20.glActiveTexture((int)this.textureId);
            GLES20.glGenTextures((int)1, (int[])this.texture, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.texture[0]);
            Bitmap bitmap = BitmapSimpleUtils.decodeBitmap(FilterManager.main_Context, this.textureResId);
            if (bitmap != null) {
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
                bitmap.recycle();
            } else {
                LogUtil.e(this, "bitmap is null");
            }
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
    }
}

