/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.content.Context;
import android.os.Environment;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.wuba.GroupInfos;
import com.wuba.api.filter.SDKConfig;
import com.wuba.api.filter.common.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;

public class JsonUtils {
    private static final String DICTIONARY = Environment.getExternalStorageDirectory().getAbsolutePath();
    private static JsonUtils Instance;
    private static final String JSONPATH = "//mnt//sdcard//tmp//sdkconfig";
    private static SDKConfig mSDKConfig;
    private Gson mGson = new Gson();

    public static JsonUtils getInstance() {
        if (Instance == null) {
            Instance = new JsonUtils();
        }
        return Instance;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <T> T fromJson(T object, String string2) {
        void var1_5;
        void var2_9;
        void var1_3;
        Object var3_10 = null;
        if (this.mGson == null) {
            Object var1_2 = var3_10;
            return var1_3;
        }
        if (object instanceof SDKConfig) {
            Type type = new TypeToken<SDKConfig>(){}.getType();
            LogUtil.d(this, "fromJson type is SDKConfig");
        } else {
            if (!(object instanceof GroupInfos)) {
                LogUtil.d(this, "fromJson type is not define");
                Object var1_8 = var3_10;
                return var1_3;
            }
            Type type = new TypeToken<GroupInfos>(){}.getType();
            LogUtil.d(this, "fromJson type is Integer");
        }
        Object object2 = this.mGson.fromJson((String)var2_9, (Type)var1_5);
        return var1_3;
    }

    public SDKConfig getSDKConfig(Context context, int n2) {
        mSDKConfig = this.readJsonFromFile(new SDKConfig(), context, n2);
        return mSDKConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readJsonFromFile(T object, Context object2, int n2) {
        JsonReader jsonReader = null;
        if (n2 == 0 || this.mGson == null || object2 == null) {
            LogUtil.d(this, "readJsonFromFile parameter is null");
            object = jsonReader;
            return (T)object;
        }
        LogUtil.d(this, "read config from raw");
        object2 = object2.getResources().openRawResource(n2);
        if (object2 == null) {
            LogUtil.d(this, "read config from raw error");
            object = jsonReader;
            return (T)object;
        }
        if (object instanceof SDKConfig) {
            object = new TypeToken<SDKConfig>(){}.getType();
            LogUtil.d(this, "readJsonFromFile type is SDKConfig");
        } else {
            if (!(object instanceof GroupInfos)) {
                LogUtil.d(this, "readJsonFromFile type is not define");
                object = jsonReader;
                return (T)object;
            }
            object = new TypeToken<GroupInfos>(){}.getType();
            LogUtil.d(this, "readJsonFromFile type is Integer");
        }
        LogUtil.d(this, "readJsonFromFile JsonReader");
        jsonReader = new JsonReader(new InputStreamReader((InputStream)object2));
        object = this.mGson.fromJson(jsonReader, (Type)object);
        LogUtil.d(this, "readJsonFromFile reader:" + jsonReader.toString());
        try {
            jsonReader.close();
            ((InputStream)object2).close();
        }
        catch (Exception exception) {
            LogUtil.d(this, "readJsonFromFile exception");
        }
        LogUtil.d(this, "readJsonFromFile object:" + object.toString());
        return (T)object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <T> String toJson(T object) {
        void var1_3;
        Type type = null;
        if (this.mGson == null) {
            Type type2 = type;
            return var1_3;
        }
        if (object instanceof SDKConfig) {
            type = new TypeToken<SDKConfig>(){}.getType();
            LogUtil.d(this, "toJson type is SDKConfig");
        } else {
            if (!(object instanceof GroupInfos)) {
                LogUtil.d(this, "toJson type is not define");
                Type type3 = type;
                return var1_3;
            }
            type = new TypeToken<GroupInfos>(){}.getType();
            LogUtil.d(this, "toJson type is Integer");
        }
        String string2 = this.mGson.toJson(object, type);
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void writeJson2File(T t2, String object) {
        FileOutputStream fileOutputStream;
        if (t2 == null || object == null || this.mGson == null) {
            LogUtil.d(this, "writeJson2File parameter is null");
            return;
        }
        Object object2 = new File((String)object);
        try {
            fileOutputStream = new FileOutputStream((File)object2);
            object2 = new JsonWriter(new OutputStreamWriter(fileOutputStream));
        }
        catch (Exception exception) {
            LogUtil.d(this, "writeJson2File FileOutputStream path:" + (String)object + " error:" + exception.toString());
            return;
        }
        if (t2 instanceof SDKConfig) {
            object = new TypeToken<SDKConfig>(){}.getType();
            LogUtil.d(this, "writeJson2File type is SDKConfig");
        } else {
            if (!(t2 instanceof GroupInfos)) {
                LogUtil.d(this, "writeJson2File type is not define");
                return;
            }
            object = new TypeToken<GroupInfos>(){}.getType();
            LogUtil.d(this, "writeJson2File type is FilterPropertyMap");
        }
        this.mGson.toJson(t2, (Type)object, (JsonWriter)object2);
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (Exception exception) {
            LogUtil.d(this, "writeJson2File close error:" + exception.toString());
            return;
        }
    }
}

