/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.filters;

import android.os.Parcel;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.GLParam;
import com.wuba.api.filter.GLSLRender;

public class ColorFilter
extends BaseFilterDes {
    private float mBrightness = 0.5f;
    private float mContrast = 0.5f;
    private float mSaturation = 0.5f;
    private float mScaleC = 0.5f;
    private float mScaleT = 0.5f;
    private int mType;

    /*
     * Enabled aggressive block sorting
     */
    public ColorFilter(int n2) {
        super("DepthFilter", GLSLRender.FILTER_SHADER_NONE, 0);
        this.mType = n2;
        switch (this.mType) {
            case 4: {
                this.fragmentShaderID = GLSLRender.FILTER_VIBRANCE;
            }
            default: {
                return;
            }
            case 5: 
        }
        this.fragmentShaderID = GLSLRender.FILTER_COLOR_TEMPERATURE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ColorFilter(Parcel parcel) {
        super(parcel);
        this.mType = parcel.readInt();
        this.mScaleC = parcel.readFloat();
        this.mScaleT = parcel.readFloat();
        this.mContrast = parcel.readFloat();
        this.mSaturation = parcel.readFloat();
        this.mBrightness = parcel.readFloat();
        switch (this.mType) {
            case 4: {
                this.fragmentShaderID = GLSLRender.FILTER_VIBRANCE;
            }
            default: {
                return;
            }
            case 5: 
        }
        this.fragmentShaderID = GLSLRender.FILTER_COLOR_TEMPERATURE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseFilter newFilter() {
        BaseFilter baseFilter = super.newFilter();
        if (this.mType == 4) {
            baseFilter.addParam(new GLParam.FloatGLParam("contrast", this.mContrast + 0.5f));
            baseFilter.addParam(new GLParam.FloatGLParam("saturation", this.mSaturation * 2.0f));
            baseFilter.addParam(new GLParam.FloatGLParam("brightness", this.mBrightness + 0.5f));
            return baseFilter;
        }
        baseFilter.addParam(new GLParam.FloatGLParam("scaleC", (this.mScaleC - 0.5f) * 1.5f));
        baseFilter.addParam(new GLParam.FloatGLParam("scaleT", (this.mScaleT - 0.5f) * 1.5f));
        return baseFilter;
    }

    public void setColorAdjustParam(float f2, float f3, float f4) {
        this.mContrast = f2;
        this.mSaturation = f3;
        this.mBrightness = f4;
    }

    public void setColorTemParam(float f2, float f3) {
        this.mScaleC = f2;
        this.mScaleT = f3;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeInt(this.mType);
        parcel.writeFloat(this.mScaleC);
        parcel.writeFloat(this.mScaleT);
        parcel.writeFloat(this.mContrast);
        parcel.writeFloat(this.mSaturation);
        parcel.writeFloat(this.mBrightness);
    }
}

