/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;
import com.wuba.cache.util.StringUtils;
import com.wuba.video.R;

public class NetworkUtil {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static netType getAPNType(Context object) {
        void var0_3;
        try {
            NetworkInfo networkInfo = ((ConnectivityManager)object.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null) {
                netType netType2 = netType.noneNet;
                return var0_3;
            }
            int n2 = networkInfo.getType();
            if (n2 == 0) {
                String string2 = networkInfo.getExtraInfo();
                if (!StringUtils.isBlank(string2) && string2.toLowerCase().equals("cmnet")) {
                    netType netType3 = netType.CMNET;
                    return var0_3;
                }
                netType netType4 = netType.CMWAP;
                return var0_3;
            }
            if (n2 == 1) {
                netType netType5 = netType.wifi;
                return var0_3;
            }
            netType netType6 = netType.unkonwnNet;
            return var0_3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            netType netType7 = netType.noneNet;
            return var0_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getConnectedType(Context context) {
        if (context == null) return -1;
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) == null) return -1;
        if (!context.isAvailable()) return -1;
        return context.getType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMobileConnected(Context context) {
        if (context == null) return false;
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) == null) return false;
        return context.isAvailable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNetworkAvailable(Context networkInfoArray) {
        int n2;
        boolean bl;
        boolean bl2 = false;
        networkInfoArray = (NetworkInfo[])networkInfoArray.getSystemService("connectivity");
        try {
            networkInfoArray = networkInfoArray.getAllNetworkInfo();
            bl = bl2;
            if (networkInfoArray == null) return bl;
            n2 = 0;
        }
        catch (Exception exception) {
            return bl2;
        }
        while (true) {
            bl = bl2;
            if (n2 >= networkInfoArray.length) return bl;
            if (networkInfoArray[n2].getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNetworkConnected(Context context) {
        if (context == null) return false;
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null) {
            if (networkInfo.isConnectedOrConnecting()) return true;
        }
        Toast.makeText((Context)context, (int)R.string.no_network_connection_toast, (int)1).show();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWifiConnected(Context context) {
        if (context == null) return false;
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) == null) return false;
        return context.isAvailable();
    }

    public static enum netType {
        wifi,
        CMNET,
        CMWAP,
        unkonwnNet,
        noneNet;

    }
}

