/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.util;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import com.wuba.recorder.util.LogUtils;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    public static final String INDIVIDUAL_DIR_NAME = "local";
    private static final String TAG = StorageUtils.class.getSimpleName();

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        File file = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            file = StorageUtils.getExternalCacheDir(context);
        }
        File file2 = file;
        if (file == null) {
            file2 = context.getCacheDir();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getExternalCacheDir(Context object) {
        void var0_3;
        File file;
        File file2 = file = new File(new File(new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data"), object.getPackageName()), "cache");
        if (!file.exists()) {
            if (!file.mkdirs()) {
                LogUtils.e(TAG, "Unable to create external cache directory");
                return var0_3;
            }
        } else {
            return var0_3;
        }
        try {
            File file3 = new File(file, ".nomedia");
            file3.createNewFile();
            File file4 = file;
            return var0_3;
        }
        catch (IOException iOException) {
            LogUtils.i(TAG, "Can't create \".nomedia\" file in application external cache directory");
            File file5 = file;
            return var0_3;
        }
    }

    private static File getExternalPersistDir(Context object) {
        File file = new File(new File(new File(new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data"), object.getPackageName()), "files"), "persist");
        object = file;
        if (!file.exists()) {
            object = file;
            if (!file.mkdirs()) {
                LogUtils.e(TAG, "Unable to create external cache directory");
                object = null;
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long getFolderSize(File fileArray) throws Exception {
        long l2 = 0L;
        fileArray = fileArray.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            l2 = fileArray[n2].isDirectory() ? (l2 += StorageUtils.getFolderSize(fileArray[n2])) : (l2 += fileArray[n2].length());
            ++n2;
        }
        return l2;
    }

    public static long getFolderSizeWithoutChildFolder(File fileArray) throws Exception {
        long l2 = 0L;
        fileArray = fileArray.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            long l3 = l2;
            if (!fileArray[i2].isDirectory()) {
                l3 = l2 + fileArray[i2].length();
            }
            l2 = l3;
        }
        return l2;
    }

    public static File getIndividualCacheDirectory(Context object) {
        File file = StorageUtils.getCacheDirectory((Context)object);
        if (!((File)(object = new File(file, INDIVIDUAL_DIR_NAME))).exists() && !((File)object).mkdir()) {
            object = file;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getIndividualCacheDirectory(Context object, String object2) {
        void var0_2;
        File file;
        File file2 = StorageUtils.getCacheDirectory(object);
        file = new File(file2, (String)((Object)file));
        if (!file.exists() && !file.mkdir()) {
            return var0_2;
        }
        File file3 = file;
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getIndividualPicCacheDirectory(Context object, String object2) {
        void var0_2;
        File file;
        File file2 = StorageUtils.getPicCacheDirectory(object);
        file = new File(file2, (String)((Object)file));
        if (!file.exists() && !file.mkdir()) {
            return var0_2;
        }
        File file3 = file;
        return var0_2;
    }

    public static File getOwnCacheDirectory(Context context, String object) {
        block5: {
            block4: {
                File file = null;
                if (Environment.getExternalStorageState().equals("mounted")) {
                    file = new File(Environment.getExternalStorageDirectory(), (String)object);
                }
                if (file == null) break block4;
                object = file;
                if (file.exists()) break block5;
                object = file;
                if (file.mkdirs()) break block5;
            }
            object = context.getCacheDir();
        }
        return object;
    }

    public static File getPersistDirectory(Context context) {
        File file = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            file = StorageUtils.getExternalPersistDir(context);
        }
        return file;
    }

    public static File getPicCacheDirectory(Context context) {
        File file = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            file = StorageUtils.getPicExternalCacheDir(context);
        }
        File file2 = file;
        if (file == null) {
            file2 = context.getCacheDir();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getPicExternalCacheDir(Context object) {
        void var0_3;
        File file;
        File file2 = file = new File(new File(new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data"), object.getPackageName()), "cache");
        if (!file.exists()) {
            if (!file.mkdirs()) {
                LogUtils.e(TAG, "Unable to create external cache directory");
                return var0_3;
            }
        } else {
            return var0_3;
        }
        try {
            File file3 = new File(file, ".nomedia");
            file3.createNewFile();
            File file4 = file;
            return var0_3;
        }
        catch (IOException iOException) {
            LogUtils.i(TAG, "Can't create \".nomedia\" file in application external cache directory");
            File file5 = file;
            return var0_3;
        }
    }

    public static int getTotalCacheSize(Context context) {
        context = new StatFs(StorageUtils.getCacheDirectory(context).getPath());
        long l2 = context.getBlockSize();
        return (int)((long)context.getBlockCount() * l2 / 1024L / 1024L);
    }

    public static long readCacheSize(Context context) {
        context = new StatFs(StorageUtils.getCacheDirectory(context).getPath());
        long l2 = context.getBlockSize();
        long l3 = context.getBlockCount();
        return (long)context.getAvailableBlocks() * l2 / 1024L / 1024L;
    }
}

