/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.controller;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.os.AsyncTask;
import com.wuba.recorder.ffmpeg.FFmpegClip;
import com.wuba.recorder.util.LogUtils;
import com.wuba.recorder.util.MP4ParserUtil;
import com.wuba.recorder.util.MediaSaveUtil;
import com.wuba.recorder.util.VideoFileUtil;
import com.wuba.recorder.v;
import com.wuba.video.ComposeVideoCallback;
import java.io.File;

public class ClipVideoTask
extends AsyncTask<Void, Integer, String> {
    private static final int ALLOW_GAP = 100;
    private static final int FORWARD_OFFSET = 200;
    private static final String TAG = ClipVideoTask.class.getSimpleName();
    private ComposeVideoCallback mCallback;
    private Context mContext;
    private int mDurationMS;
    private v mFinalClip = new v();
    private String mFinalVideoPath = null;
    private int mOrientation;
    private String mPath;
    private int mTimeEnd;
    private int mTimeStart;
    private int mTotalTimeSpan;

    public ClipVideoTask(Context context, String string2, int n2, int n3, ComposeVideoCallback composeVideoCallback) {
        String string3 = String.format("TimeStart:%d TimeEnd:%d", n2, n3);
        this.mContext = context;
        context = new MediaMetadataRetriever();
        context.setDataSource(string2);
        this.mDurationMS = Integer.parseInt(context.extractMetadata(9));
        this.mTimeStart = n2;
        this.mTimeEnd = n3;
        this.mTotalTimeSpan = this.mTimeEnd - this.mTimeStart;
        this.mPath = string2;
        this.mCallback = composeVideoCallback;
        LogUtils.d("NYF", string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doEasyShorten() {
        String string2 = this.mFinalVideoPath;
        if (this.mTimeStart < 100 && this.mTimeEnd > this.mDurationMS - 100) {
            MediaSaveUtil.copyVideoFile(new File(this.mPath), new File(this.mFinalVideoPath));
        } else {
            FFmpegClip.shortenVideo2(this.mPath, this.mFinalVideoPath, this.mTimeStart, this.mTimeEnd);
            if (this.mOrientation != 0) {
                string2 = VideoFileUtil.generateVideoFilename("", this.mContext);
                MP4ParserUtil.rotateVideo(this.mFinalVideoPath, string2, this.mOrientation);
                VideoFileUtil.deleteFile(this.mFinalVideoPath);
            }
        }
        this.mFinalClip.mOrientation = 0;
        this.mFinalClip.dO = string2;
        this.mFinalClip.dT = this.mFinalClip.dP = (long)(MP4ParserUtil.getDuration(string2) * 1000.0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doInBackground(Void ... object) {
        void var1_3;
        try {
            this.mFinalVideoPath = VideoFileUtil.generateVideoFilename("clip_video", this.mContext);
            this.mOrientation = MP4ParserUtil.getVideoOrientation(this.mPath);
            this.doEasyShorten();
            String string2 = this.mFinalVideoPath;
            return var1_3;
        }
        catch (Exception exception) {
            return var1_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onPostExecute(String string2) {
        if (new File(this.mFinalClip.dO).exists()) {
            this.mCallback.onVideoEditResultPath(this.mFinalClip.dO);
            return;
        }
        this.mCallback.onGenVideoFailed();
    }

    protected void onPreExecute() {
    }

    protected void onProgressUpdate(Integer ... integerArray) {
        this.mCallback.onComposeProgress(integerArray[0]);
    }

    public void startExec() {
        this.execute(new Void[0]);
    }
}

