/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.ffmpeg;

import android.graphics.Bitmap;
import com.wuba.recorder.ffmpeg.FFmpegException;
import com.wuba.recorder.ffmpeg.FFmpegGrabber;
import com.wuba.recorder.ffmpeg.Frame;
import com.wuba.recorder.ffmpeg.IplImage;
import com.wuba.recorder.util.LogUtils;
import java.nio.Buffer;

public class FFmpegRecorder {
    public static final int AUDIO_MIX_MODE_ALL = 0;
    public static final int AUDIO_MIX_MODE_MUTE = 3;
    public static final int AUDIO_MIX_MODE_ONLY_MUSIC = 1;
    public static final int AUDIO_MIX_MODE_ONLY_OWNER = 2;
    public static final int DEFAULT_FRAME_RATE = 24;
    private int nativeId = -1;

    static {
        Frame.loadLibrary();
    }

    public FFmpegRecorder(String string2, int n2, int n3, int n4) {
        this.nativeAllocate(string2, n2, n3, n4);
    }

    private native boolean nativeAllocate(String var1, int var2, int var3, int var4);

    private native boolean nativeDeallocate();

    private native boolean recordFormatImage(IplImage var1, int var2) throws FFmpegException;

    private native void recordFrame(Frame var1) throws FFmpegException;

    private native boolean recordNioBufferSamples(Buffer[] var1, int var2, int var3) throws FFmpegException;

    private native boolean recordSamples(Buffer[] var1) throws FFmpegException;

    private boolean recordYUVFrame(byte[] byArray, int n2, int n3) throws FFmpegException {
        return this.recordYUVFrame(byArray, n2, n3, 26);
    }

    private native boolean recordYUVFrame(byte[] var1, int var2, int var3, int var4) throws FFmpegException;

    private void releaseNativeAllocation() {
        synchronized (this) {
            this.nativeDeallocate();
            this.nativeId = -1;
            return;
        }
    }

    public native String addAudio(String var1, String var2);

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.hasNativeAllocation()) {
            LogUtils.d("NYF", "release===3");
            this.release();
        }
    }

    public native void flush() throws FFmpegException;

    public native int getAudioBitrate();

    public native int getAudioChannels();

    public native int getAudioCodec();

    public native String getAudioOption(String var1);

    public native double getAudioQuality();

    public native String getFormat();

    public native int getFrameNumber();

    public native double getFrameRate();

    public native int getImageHeight();

    public native int getImageWidth();

    public native int getPixelFormat();

    public native int getSampleFormat();

    public native int getSampleRate();

    public native long getTimestamp();

    public native long getTimestampAudio();

    public native long getTimestampVideo();

    public native int getVideoBitrate();

    public native int getVideoCodec();

    public native String getVideoOption(String var1);

    public native double getVideoQuality();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNativeAllocation() {
        synchronized (this) {
            int n2 = this.nativeId;
            if (n2 == -1) return false;
            return true;
        }
    }

    public native boolean isInterleaved();

    public native void mixAudio(Frame var1, Frame var2);

    public native void nativeRelease();

    public native boolean recordBitmap(Bitmap var1) throws FFmpegException;

    public native boolean recordBitmap2(Bitmap var1) throws FFmpegException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recordFrameNoException(Frame frame) {
        try {
            this.recordFrame(frame);
            return;
        }
        catch (FFmpegException fFmpegException) {
            fFmpegException.printStackTrace();
            return;
        }
    }

    public native boolean recordImage(IplImage var1) throws FFmpegException;

    public native boolean recordNioBufferMonoSamples(Buffer var1, int var2, int var3) throws FFmpegException;

    public void release() {
        LogUtils.d("NYF", "release===1");
        this.nativeRelease();
        if (this.hasNativeAllocation()) {
            LogUtils.d("NYF", "release===2");
            this.releaseNativeAllocation();
        }
    }

    public native void setAudioBitrate(int var1);

    public native void setAudioChannels(int var1);

    public native void setAudioCodec(int var1);

    public native void setAudioMixMode(int var1);

    public native void setAudioOption(String var1, String var2);

    public native void setAudioQuality(double var1);

    public native void setFormat(String var1);

    public native void setFrameNumber(int var1);

    public native void setFrameRate(double var1);

    public native void setImageHeight(int var1);

    public native void setImageWidth(int var1);

    public native void setInterleaved(boolean var1);

    public native void setLogoStartFlag(boolean var1);

    public native void setMusicMixGrabber(FFmpegGrabber var1);

    public native void setMusicMixVolumeRate(double var1);

    public native void setPixelFormat(int var1);

    public native void setSampleFormat(int var1);

    public native void setSampleRate(int var1);

    public native void setSilence(boolean var1);

    public native void setSourceHasAudioStream(boolean var1);

    public native void setTimeTotal(long var1);

    public native void setTimestamp(long var1);

    public native void setVideoBitrate(int var1);

    public native void setVideoCodec(int var1);

    public native void setVideoOption(String var1, String var2);

    public native void setVideoQuality(double var1);

    public native void start() throws FFmpegException;

    public native void stop() throws FFmpegException;
}

