/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.ffmpeg;

import com.wuba.recorder.ffmpeg.FFmpegRecorder;

public class RecorderConfig {
    public static final int AV_SAMPLE_FMT_DBL = 4;
    public static final int AV_SAMPLE_FMT_DBLP = 9;
    public static final int AV_SAMPLE_FMT_FLT = 3;
    public static final int AV_SAMPLE_FMT_FLTP = 8;
    public static final int AV_SAMPLE_FMT_NONE = -1;
    public static final int AV_SAMPLE_FMT_S16 = 1;
    public static final int AV_SAMPLE_FMT_S16P = 6;
    public static final int AV_SAMPLE_FMT_S32 = 2;
    public static final int AV_SAMPLE_FMT_S32P = 7;
    public static final int AV_SAMPLE_FMT_U8 = 0;
    public static final int AV_SAMPLE_FMT_U8P = 5;
    public static final int CONFIG_TYPE_H264 = 1;
    public static final int CONFIG_TYPE_H264_HIGH = 4;
    public static final int CONFIG_TYPE_MPEG4 = 2;
    public static final int CONFIG_TYPE_MPEG4_HIGH = 3;
    public static final int DEFAULT_AUDIO_CHANNELS = 2;
    public static final String DEFAULT_CONTAINER_FORMAT = "mp4";
    public static final int DEFAULT_FRAME_RATE = 24;
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_TARGET_VIDEO_HEIGHT = 480;
    public static final int DEFAULT_TARGET_VIDEO_WIDTH = 480;
    public static final int DEFAULT_VIDEO_BITRATE = 1200000;
    public static final int LONG_VIDEO_HEIGHT = 360;
    public static final int LONG_VIDEO_WIDTH = 480;
    public static short[] SAMPLE_CHANNEL_LIST;
    public static short[] SAMPLE_FROMAT_LIST;
    public static int[] SAMPLE_RATE_LIST;
    public static final int VIDEO_BITRATE_HIGH = 1200000;
    public static final String h264_CONTAINER_FORMAT = "h264";
    public int audioChannels;
    public int audioCodec;
    public String format;
    public int frameRate;
    public int sampleAudioRateInHz;
    public int sampleFormat;
    public int targetHeight;
    public int targetWidth;
    public int videoBitrate;
    public int videoCodec;
    public int videoQuality;

    static {
        SAMPLE_RATE_LIST = new int[]{44100, 48000, 22050, 16000, 11025, 8000};
        SAMPLE_FROMAT_LIST = new short[]{2, 3};
        SAMPLE_CHANNEL_LIST = new short[]{16, 12};
    }

    private RecorderConfig() {
    }

    public static RecorderConfig createH264Config() {
        RecorderConfig recorderConfig = new RecorderConfig();
        recorderConfig.format = DEFAULT_CONTAINER_FORMAT;
        recorderConfig.sampleAudioRateInHz = 44100;
        recorderConfig.audioCodec = 86018;
        recorderConfig.audioChannels = 2;
        recorderConfig.sampleFormat = 8;
        recorderConfig.frameRate = 24;
        recorderConfig.videoBitrate = 1200000;
        recorderConfig.videoCodec = 28;
        recorderConfig.targetWidth = 480;
        recorderConfig.targetHeight = 480;
        return recorderConfig;
    }

    public static RecorderConfig createH264HighConfig() {
        RecorderConfig recorderConfig = RecorderConfig.createH264Config();
        recorderConfig.videoBitrate = 1200000;
        return recorderConfig;
    }

    public static RecorderConfig createMPEG4Config() {
        RecorderConfig recorderConfig = RecorderConfig.createH264Config();
        recorderConfig.videoCodec = 13;
        return recorderConfig;
    }

    public static RecorderConfig createMPEG4HighConfig() {
        RecorderConfig recorderConfig = RecorderConfig.createMPEG4Config();
        recorderConfig.videoBitrate = 1200000;
        return recorderConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RecorderConfig createRecorderConfig(int n2) {
        switch (n2) {
            default: {
                return RecorderConfig.createMPEG4Config();
            }
            case 4: {
                return RecorderConfig.createH264HighConfig();
            }
            case 1: {
                return RecorderConfig.createH264Config();
            }
            case 3: 
        }
        return RecorderConfig.createMPEG4HighConfig();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setRecorderConfig(FFmpegRecorder fFmpegRecorder, int n2) {
        RecorderConfig recorderConfig = RecorderConfig.createRecorderConfig(n2);
        try {
            fFmpegRecorder.setFrameRate(recorderConfig.frameRate);
            fFmpegRecorder.setVideoBitrate(recorderConfig.videoBitrate);
            fFmpegRecorder.setVideoCodec(recorderConfig.videoCodec);
            fFmpegRecorder.setAudioChannels(recorderConfig.audioChannels);
            fFmpegRecorder.setAudioCodec(recorderConfig.audioCodec);
            fFmpegRecorder.setSampleRate(recorderConfig.sampleAudioRateInHz);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return;
        }
    }
}

