/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.util;

import android.graphics.Bitmap;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.wuba.recorder.util.LogUtils;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class OpenGlUtils {
    public static final int NO_TEXTURE = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int loadProgram(String string2, String string3) {
        int n2 = 0;
        int[] nArray = new int[1];
        int n3 = OpenGlUtils.loadShader(string2, 35633);
        if (n3 == 0) {
            LogUtils.d("Load Program", "Vertex Shader Failed");
            return n2;
        }
        int n4 = OpenGlUtils.loadShader(string3, 35632);
        if (n4 == 0) {
            LogUtils.d("Load Program", "Fragment Shader Failed");
            return n2;
        }
        int n5 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n5, (int)n3);
        GLES20.glAttachShader((int)n5, (int)n4);
        GLES20.glLinkProgram((int)n5);
        GLES20.glGetProgramiv((int)n5, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] <= 0) {
            LogUtils.d("Load Program", "Linking Failed");
            return n2;
        }
        GLES20.glDeleteShader((int)n3);
        GLES20.glDeleteShader((int)n4);
        return n5;
    }

    public static int loadShader(String string2, int n2) {
        int n3 = 0;
        int[] nArray = new int[1];
        n2 = GLES20.glCreateShader((int)n2);
        GLES20.glShaderSource((int)n2, (String)string2);
        GLES20.glCompileShader((int)n2);
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            LogUtils.d("Load Shader Failed", "Compilation\n" + GLES20.glGetShaderInfoLog((int)n2));
            n2 = n3;
        }
        return n2;
    }

    public static int loadTexture(Bitmap bitmap, int n2) {
        return OpenGlUtils.loadTexture(bitmap, n2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int loadTexture(Bitmap bitmap, int n2, boolean bl) {
        int[] nArray = new int[1];
        if (n2 == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)n2);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap);
            nArray[0] = n2;
        }
        if (bl) {
            bitmap.recycle();
        }
        return nArray[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int loadTexture(IntBuffer intBuffer, Camera.Size size, int n2) {
        int[] nArray = new int[1];
        if (n2 == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)size.width, (int)size.height, (int)0, (int)6408, (int)5121, (Buffer)intBuffer);
            return nArray[0];
        }
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)size.width, (int)size.height, (int)6408, (int)5121, (Buffer)intBuffer);
        nArray[0] = n2;
        return nArray[0];
    }

    public static int loadTextureAsBitmap(IntBuffer intBuffer, Camera.Size size, int n2) {
        return OpenGlUtils.loadTexture(Bitmap.createBitmap((int[])intBuffer.array(), (int)size.width, (int)size.height, (Bitmap.Config)Bitmap.Config.ARGB_8888), n2);
    }

    public static float rnd(float f2, float f3) {
        return (float)Math.random() * (f3 - f2) + f2;
    }
}

