/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.video.filterIcon;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.GLFrame;
import com.wuba.api.filter.GLSLRender;
import com.wuba.api.filter.WImage;
import com.wuba.api.filter.common.LogUtil;
import com.wuba.api.filter.filters.FaceDetectFilter;
import com.wuba.api.filter.filters.LensFilter;
import com.wuba.recorder.util.LogUtils;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class FilterIconProcess {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final String TAG = FilterIconProcess.class.getSimpleName();
    private final int[] CONFIG_SPEC = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12344};
    private EGL10 mEgl;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    BaseFilter mFilter = new LensFilter().newFilter();
    private int mFilterId;
    private boolean mHasInit = false;
    GLFrame mPictureGLFrame = new GLFrame();

    private EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
        int[] nArray = new int[1];
        if (!eGL10.eglChooseConfig(eGLDisplay, this.CONFIG_SPEC, null, 0, nArray)) {
            throw new RuntimeException("failed to eglMakeCurrent");
        }
        int n2 = nArray[0];
        if (n2 <= 0) {
            throw new IllegalArgumentException("No configs match configSpec");
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[n2];
        if (!eGL10.eglChooseConfig(eGLDisplay, this.CONFIG_SPEC, eGLConfigArray, n2, nArray)) {
            throw new IllegalArgumentException("eglChooseConfig#2 failed");
        }
        return eGLConfigArray[0];
    }

    private void doInitGL() {
        this.release();
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] nArray = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
            throw new RuntimeException("eglInitialize failed");
        }
        LogUtils.v(TAG, "EGL version: " + nArray[0] + '.' + nArray[1]);
        this.mEglConfig = this.chooseConfig(this.mEgl, this.mEglDisplay);
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, this.mEglConfig, EGL10.EGL_NO_CONTEXT, new int[]{12440, 2, 12344});
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("failed to createContext");
        }
        try {
            this.mEglSurface = this.mEgl.eglCreatePbufferSurface(this.mEglDisplay, this.mEglConfig, new int[]{12375, 2, 12374, 2, 12344});
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                throw new RuntimeException("failed to createWindowSurface");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new RuntimeException("failed to createWindowSurface");
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            throw new RuntimeException("failed to eglMakeCurrent");
        }
    }

    private void doRelease() {
        this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
        this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEgl.eglTerminate(this.mEglDisplay);
        this.mEglSurface = null;
        this.mEglContext = null;
        this.mEglDisplay = null;
        this.mEgl = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeFilter(BaseFilterDes baseFilterDes) {
        if (this.mFilter != null && this.mFilter.isSameFilter(baseFilterDes)) {
            return;
        }
        if (this.mFilter != null) {
            this.mFilter.ClearGLSL();
        }
        this.mFilter = baseFilterDes.newFilter();
        this.mFilter.ApplyGLSLFilter(true);
    }

    public void init() {
        if (!this.mHasInit) {
            this.doInitGL();
            this.mHasInit = true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Bitmap makeFilter(Bitmap bitmap, boolean bl) {
        void var3_4;
        if (bitmap == null || bitmap.isRecycled() || !this.mHasInit) {
            Object var3_3 = null;
            return var3_4;
        }
        long l2 = System.currentTimeMillis();
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mFilter.ApplyGLSLFilter(false);
        if (this.mFilter.isGPUProcess()) {
            int[] nArray = new int[1];
            GLES20.glGenTextures((int)nArray.length, (int[])nArray, (int)0);
            if (this.mFilter instanceof FaceDetectFilter.FaceDetectBaseFilter) {
                ((FaceDetectFilter.FaceDetectBaseFilter)this.mFilter).initial(bitmap, 0);
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (int)GLUtils.getInternalFormat((Bitmap)bitmap), (Bitmap)bitmap, (int)GLUtils.getType((Bitmap)bitmap), (int)0);
            long l3 = System.currentTimeMillis();
            this.mFilter.RenderProcess(nArray[0], bitmap.getWidth(), bitmap.getHeight(), -1, 0.0, this.mPictureGLFrame);
            LogUtil.d(this, "nativeRenderTexture :" + (System.currentTimeMillis() - l3));
            l3 = System.currentTimeMillis();
            GLSLRender.nativeCopyPixelToBitmap(bitmap2);
            LogUtil.d(this, "nativeCopyPixelToBitmap :" + (System.currentTimeMillis() - l3));
            GLES20.glDeleteTextures((int)nArray.length, (int[])nArray, (int)0);
        } else {
            WImage wImage = WImage.Bitmap2WImage(bitmap);
            this.mFilter.ApplyFilter(wImage);
            wImage.ToBitmap(bitmap2);
            wImage.Dispose();
        }
        if (this.mFilter != null) {
            this.mFilter.ApplyGLSLFilter(true);
        }
        LogUtil.d(this, "makeFilter :" + (System.currentTimeMillis() - l2));
        l2 = System.currentTimeMillis();
        int[] nArray = new int[bitmap2.getWidth() * bitmap2.getHeight()];
        int[] nArray2 = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap2.getPixels(nArray, 0, bitmap2.getWidth(), 0, 0, bitmap2.getWidth(), bitmap2.getHeight());
        bitmap.getPixels(nArray2, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = nArray2[i2] & 0xFF000000 | nArray[i2] & 0xFFFFFF;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int[])nArray, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        LogUtils.d(TAG, "setData, pixel:" + (System.currentTimeMillis() - l2));
        if (bitmap2 != null && !bitmap2.isRecycled()) {
            bitmap2.recycle();
        }
        Bitmap bitmap4 = bitmap3;
        if (!bl) return var3_4;
        Bitmap bitmap5 = bitmap3;
        if (bitmap == null) return var3_4;
        Bitmap bitmap6 = bitmap3;
        if (bitmap.isRecycled()) return var3_4;
        bitmap.recycle();
        Bitmap bitmap7 = bitmap3;
        return var3_4;
    }

    public void release() {
        if (this.mHasInit) {
            this.doRelease();
            this.mHasInit = false;
        }
    }
}

