/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class EPSG2SDO {
    private static HashMap epsg_sdo_ids = null;

    public static void resetMappings() {
        if (epsg_sdo_ids != null) {
            epsg_sdo_ids.clear();
        }
        epsg_sdo_ids = null;
        EPSG2SDO.createSRSMap();
    }

    private static void createSRSMap() {
        if (epsg_sdo_ids == null) {
            epsg_sdo_ids = new HashMap(100);
            epsg_sdo_ids.put("3857", "3857");
            epsg_sdo_ids.put("3875", "3857");
            epsg_sdo_ids.put("4326", "8307");
            epsg_sdo_ids.put("4269", "8265");
            epsg_sdo_ids.put("4267", "8260");
            epsg_sdo_ids.put("4202", "81920");
            epsg_sdo_ids.put("4203", "81921");
            epsg_sdo_ids.put("20248", "81922");
            epsg_sdo_ids.put("20249", "81924");
            epsg_sdo_ids.put("20250", "81926");
            epsg_sdo_ids.put("20251", "81928");
            epsg_sdo_ids.put("20252", "81930");
            epsg_sdo_ids.put("20253", "81932");
            epsg_sdo_ids.put("20254", "81934");
            epsg_sdo_ids.put("20255", "81936");
            epsg_sdo_ids.put("20256", "81938");
            epsg_sdo_ids.put("20257", "81940");
            epsg_sdo_ids.put("20258", "81942");
            epsg_sdo_ids.put("20348", "81923");
            epsg_sdo_ids.put("20349", "81925");
            epsg_sdo_ids.put("20350", "81927");
            epsg_sdo_ids.put("20351", "81929");
            epsg_sdo_ids.put("20352", "81931");
            epsg_sdo_ids.put("20353", "81933");
            epsg_sdo_ids.put("20354", "81935");
            epsg_sdo_ids.put("20355", "81937");
            epsg_sdo_ids.put("20356", "81939");
            epsg_sdo_ids.put("20357", "81941");
            epsg_sdo_ids.put("20358", "81943");
            epsg_sdo_ids.put("23028", "82323");
            epsg_sdo_ids.put("23029", "82328");
            epsg_sdo_ids.put("23030", "82337");
            epsg_sdo_ids.put("23031", "82340");
            epsg_sdo_ids.put("23032", "82343");
            epsg_sdo_ids.put("23033", "82346");
            epsg_sdo_ids.put("23034", "82349");
            epsg_sdo_ids.put("23035", "82352");
            epsg_sdo_ids.put("23036", "82355");
            epsg_sdo_ids.put("23037", "82358");
            epsg_sdo_ids.put("23038", "82361");
            epsg_sdo_ids.put("8307", "4326");
            epsg_sdo_ids.put("8265", "4269");
            epsg_sdo_ids.put("8260", "4267");
            epsg_sdo_ids.put("81920", "4202");
            epsg_sdo_ids.put("81921", "4203");
            epsg_sdo_ids.put("81922", "20248");
            epsg_sdo_ids.put("81924", "20249");
            epsg_sdo_ids.put("81926", "20250");
            epsg_sdo_ids.put("81928", "20251");
            epsg_sdo_ids.put("81930", "20252");
            epsg_sdo_ids.put("81932", "20253");
            epsg_sdo_ids.put("81934", "20254");
            epsg_sdo_ids.put("81936", "20255");
            epsg_sdo_ids.put("81938", "20256");
            epsg_sdo_ids.put("81940", "20257");
            epsg_sdo_ids.put("81942", "20258");
            epsg_sdo_ids.put("81923", "20348");
            epsg_sdo_ids.put("81925", "20349");
            epsg_sdo_ids.put("81927", "20350");
            epsg_sdo_ids.put("81929", "20351");
            epsg_sdo_ids.put("81931", "20352");
            epsg_sdo_ids.put("81933", "20353");
            epsg_sdo_ids.put("81935", "20354");
            epsg_sdo_ids.put("81937", "20355");
            epsg_sdo_ids.put("81939", "20356");
            epsg_sdo_ids.put("81941", "20357");
            epsg_sdo_ids.put("81943", "20358");
            epsg_sdo_ids.put("82323", "23028");
            epsg_sdo_ids.put("82328", "23029");
            epsg_sdo_ids.put("82337", "23030");
            epsg_sdo_ids.put("82340", "23031");
            epsg_sdo_ids.put("82343", "23032");
            epsg_sdo_ids.put("82346", "23033");
            epsg_sdo_ids.put("82349", "23034");
            epsg_sdo_ids.put("82352", "23035");
            epsg_sdo_ids.put("82355", "23036");
            epsg_sdo_ids.put("82358", "23037");
            epsg_sdo_ids.put("82361", "23038");
            epsg_sdo_ids.put("102100", "3857");
            epsg_sdo_ids.put("900913", "3857");
        }
    }

    public static String EPSGtoSDO(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        string2 = (String)epsg_sdo_ids.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String SDOtoEPSG(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        string2 = (String)epsg_sdo_ids.get(string);
        if (string2 == null) {
            return null;
        }
        return string2;
    }

    public static String NS_EPSGtoSDO(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string == null || string.length() < 6) {
            return null;
        }
        string3 = string.substring(5);
        if (string3 == null || string3.length() < 6) {
            return null;
        }
        string4 = (String)epsg_sdo_ids.get(string3);
        if (string4 == null) {
            return null;
        }
        string2 = "SDO:" + string4;
        return string2;
    }

    public static String NS_SDOtoEPSG(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string == null || string.length() < 5) {
            return null;
        }
        string4 = string.substring(4);
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        string3 = (String)epsg_sdo_ids.get(string4);
        if (string3 == null) {
            return null;
        }
        string2 = "EPSG:" + string3;
        return string2;
    }

    public static int loadFromCustomMapFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            int n = 0;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                epsg_sdo_ids.put(string2, string3);
                epsg_sdo_ids.put(string3, string2);
                ++n;
            }
            fileInputStream.close();
            return n;
        }
        catch (Exception exception) {
            System.err.println("error opening WMS srid map file: " + string);
            return 0;
        }
    }

    public static boolean addSRSMapping(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        epsg_sdo_ids.put(string, string2);
        epsg_sdo_ids.put(string2, string);
        return true;
    }

    static {
        EPSG2SDO.createSRSMap();
    }
}

