/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oci.OracleOCIConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;

    T2CDriverExtension() {
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    final Connection getConnection(String string, Properties properties, AbstractConnectionBuilder abstractConnectionBuilder) throws SQLException {
        T2CConnection t2CConnection = null;
        t2CConnection = properties.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(string, properties, (Object)this) : new T2CConnection(string, properties, this);
        t2CConnection.connect(abstractConnectionBuilder);
        return t2CConnection;
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OracleStatement allocateStatement(PhysicalConnection physicalConnection, Properties properties) throws SQLException {
        if (properties != null) {
            properties.setProperty("execute_batch", Integer.toString(1));
            properties.setProperty("row_prefetch", Integer.toString(physicalConnection.defaultRowPrefetch));
        }
        return new T2CStatement((T2CConnection)physicalConnection, properties);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, Properties properties) throws SQLException {
        if (properties != null) {
            properties.setProperty("execute_batch", Integer.toString(physicalConnection.defaultExecuteBatch));
            properties.setProperty("row_prefetch", Integer.toString(physicalConnection.defaultRowPrefetch));
        }
        return new T2CPreparedStatement((T2CConnection)physicalConnection, string, properties);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, Properties properties) throws SQLException {
        if (properties != null) {
            properties.setProperty("execute_batch", Integer.toString(physicalConnection.defaultExecuteBatch));
            properties.setProperty("row_prefetch", Integer.toString(physicalConnection.defaultRowPrefetch));
        }
        return new T2CCallableStatement((T2CConnection)physicalConnection, string, properties);
    }

    @Override
    OracleInputStream createInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) throws SQLException {
        return new T2CInputStream(oracleStatement, n2, accessor);
    }
}

