/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

public abstract class AbstractConnectionBuilder<T extends AbstractConnectionBuilder<T, U>, U> {
    private final T self = this;
    private String user = null;
    private String password = null;
    private String serviceName = null;
    private String instanceName = null;
    private OracleShardingKey shardingKey = null;
    private OracleShardingKey superShardingKey = null;
    private GSSCredential gssCredential = null;
    private SSLContext sslContext = null;

    protected AbstractConnectionBuilder() {
    }

    public final T password(@Blind String string) {
        this.password = string;
        return this.self;
    }

    public final T user(String string) {
        this.user = string;
        return this.self;
    }

    public final T serviceName(String string) {
        this.serviceName = string;
        return this.self;
    }

    public final T instanceName(String string) {
        this.instanceName = string;
        return this.self;
    }

    public final T shardingKey(OracleShardingKey oracleShardingKey) {
        this.shardingKey = oracleShardingKey;
        return this.self;
    }

    public final T superShardingKey(OracleShardingKey oracleShardingKey) {
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this.self;
    }

    public final T gssCredential(GSSCredential gSSCredential) {
        if (gSSCredential == null) {
            throw new NullPointerException();
        }
        this.gssCredential = gSSCredential;
        return this.self;
    }

    public final T sslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this.self;
    }

    public final String getUser() {
        return this.user;
    }

    @Blind
    public final String getPassword() {
        return this.password;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getInstanceName() {
        return this.instanceName;
    }

    public final OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public final OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public final GSSCredential getGSSCredential() {
        return this.gssCredential;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public T copy(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) {
        this.user = abstractConnectionBuilder.user;
        this.password = abstractConnectionBuilder.password;
        this.instanceName = abstractConnectionBuilder.instanceName;
        this.serviceName = abstractConnectionBuilder.serviceName;
        this.shardingKey = abstractConnectionBuilder.shardingKey;
        this.superShardingKey = abstractConnectionBuilder.superShardingKey;
        this.sslContext = abstractConnectionBuilder.sslContext;
        if (this.gssCredential != null) {
            this.gssCredential = abstractConnectionBuilder.gssCredential;
        }
        return this.self;
    }

    public abstract U build() throws SQLException;
}

