/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.ColumnHelperUtils;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.ReferencingObjectMapPopupDialog;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class ObjectMapValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    final int TMAP_TYPE_COL = 1;
    JTextArea textEditor;
    Connection connection;
    SqlComboBoxActionControl sqlSelectCol;
    CardLayout cardLayout;
    String editorValue = "";
    String tmtype;
    R2RMLTree tree;
    TriplesMapNode tmap;
    PredicateObjectMap pmap;
    private JButton editorComponent;
    ReferencingObjectMapPopupDialog popup;
    private String currentText = "";

    public ObjectMapValueCellEditor(R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, PredicateObjectMap predicateObjectMap, Connection connection) {
        this.connection = connection;
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.pmap = predicateObjectMap;
        this.editorComponent = new JButton();
        this.editorComponent.setBackground(Color.white);
        this.editorComponent.setBorderPainted(false);
        this.editorComponent.setContentAreaFilled(false);
        this.editorComponent.setFocusable(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, final int n, int n2) {
        this.tmtype = (String)jTable.getValueAt(n, 1);
        this.editorValue = (String)object;
        this.textEditor = new JTextArea((String)object);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                int n = ObjectMapValueCellEditor.this.textEditor.getCaretPosition();
                try {
                    ObjectMapValueCellEditor.this.textEditor.getDocument().insertString(n, "{\\\"" + jMenuItem.getText() + "\\\"}", null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, badLocationException.getMessage());
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.textEditor.add(jPopupMenu);
        this.textEditor.setComponentPopupMenu(jPopupMenu);
        this.textEditor.setFocusTraversalKeys(0, null);
        this.textEditor.setFocusTraversalKeys(1, null);
        String string = this.tmap.getCleanSource();
        String string2 = "";
        String string3 = "";
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 1) {
            string2 = stringArray[0];
            string3 = stringArray[1];
        }
        if (stringArray.length == 1) {
            string2 = "";
            string3 = stringArray[0];
        }
        if (this.tmap.getSourceType().equalsIgnoreCase(RdfgraphArb.getString("QUERY"))) {
            R2RMLStringNode r2RMLStringNode = (R2RMLStringNode)this.tmap.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#logicalTable>").getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#sqlQuery>");
            String string4 = RDFStringUtils.unescapeJavaString(r2RMLStringNode.getValue());
            string4 = RDFStringUtils.removeWrappingQuotes(string4);
            this.sqlSelectCol = new SqlComboBoxActionControl("sel_col", "Col", this.connection, "select * from dual where 1=0");
            this.sqlSelectCol.enableEditBox();
            for (String string5 : ColumnHelperUtils.getColumnsFromQuery(this.connection, string4)) {
                jPopupMenu.add(string5).addActionListener(actionListener);
                this.sqlSelectCol.getUI().addItem(string5);
            }
        } else {
            String string6 = "SELECT COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + string3 + "' ";
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
            List list = dBUtil.executeReturnList(string6, new HashMap());
            for (Map map : list) {
                jPopupMenu.add((String)map.get("COLUMN_NAME")).addActionListener(actionListener);
            }
            this.sqlSelectCol = new SqlComboBoxActionControl("sel_col", "Col", this.connection, string6);
            this.sqlSelectCol.enableEditBox();
        }
        if (this.tmtype.equals(R2RMLArb.getString("COLUMN"))) {
            this.sqlSelectCol.getUI().setSelectedItem(RDFStringUtils.stripSQLName(this.editorValue));
            return this.sqlSelectCol.getUI();
        }
        if (this.tmtype.equals(R2RMLArb.getString("REFERENCE"))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ObjectMapValueCellEditor.this.popup = new ReferencingObjectMapPopupDialog(ObjectMapValueCellEditor.this.connection, ObjectMapValueCellEditor.this.tree, ObjectMapValueCellEditor.this.tmap, (ObjectMapNode)ObjectMapValueCellEditor.this.pmap.getObjectMaps().get(n));
                    ObjectMapValueCellEditor.this.popup.setLocationRelativeTo(SwingUtilities.getWindowAncestor(ObjectMapValueCellEditor.this.editorComponent));
                    ObjectMapValueCellEditor.this.popup.show();
                    ObjectMapValueCellEditor.this.fireEditingStopped();
                }
            });
            this.currentText = object.toString();
            this.editorComponent.setText(this.currentText);
            return this.editorComponent;
        }
        return this.textEditor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.tmtype.equals(R2RMLArb.getString("COLUMN"))) {
            String string = (String)this.sqlSelectCol.getUI().getSelectedItem();
            return "\"\\\"" + string + "\\\"\"";
        }
        if (this.tmtype.equals(R2RMLArb.getString("REFERENCE"))) {
            return this.currentText;
        }
        return this.textEditor.getText();
    }
}

