/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.language;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.LogicalTableNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectMapNode;

public class TriplesMapNode
extends R2RMLNode {
    public static final String BASE_LABEL = R2RMLArb.getString("TRIPLES_MAP");
    LogicalTableNode logicalTableNode = null;

    public String getTriplesSource() {
        if (this.getLogicalTableNode() != null) {
            return this.getLogicalTableNode().getTableName();
        }
        return R2RMLArb.getString("_UNDEFINED_");
    }

    public String getSourceType() {
        return this.getLogicalTableNode().getSourceType();
    }

    public LogicalTableNode getLogicalTableNode() {
        return (LogicalTableNode)this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#logicalTable>");
    }

    public TriplesMapNode(String string) {
        super(string, "<http://www.w3.org/ns/r2rml#TriplesMap>");
    }

    @Override
    public String getDescription() {
        String string;
        try {
            string = URLDecoder.decode(this.getTriplesSource(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = this.getTriplesSource();
        }
        String string2 = R2RMLArb.getString("GENERATES_TRIPLES_FROM") + string + " " + this.getSourceType();
        string2 = string2.replaceAll("\\\"", "");
        string2 = string2.replaceAll("\\\\", "");
        return string2;
    }

    public String getCleanSource() {
        String string = this.getTriplesSource().replaceAll("\\\"", "");
        string = string.replaceAll("\\\\", "");
        return string;
    }

    @Override
    public void addChildEdge(String string, R2RMLNode r2RMLNode) {
        super.addChildEdge(string, r2RMLNode);
    }

    @Override
    public void compile() {
        this.getChildEdges().sort((pair, pair2) -> {
            if (pair.second() instanceof LogicalTableNode) {
                return -1;
            }
            if (pair2.second() instanceof LogicalTableNode) {
                return 1;
            }
            if (pair.second() instanceof SubjectMapNode) {
                if (pair2.second() instanceof TriplesMapNode) {
                    return 1;
                }
                return -1;
            }
            if (pair2.second() instanceof SubjectMapNode) {
                if (pair.second() instanceof TriplesMapNode) {
                    return -1;
                }
                return 1;
            }
            return 0;
        });
    }

    public SubjectMapNode getSubjectMapNode() {
        if (this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#subject>") != null) {
            return (SubjectMapNode)this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#subject>");
        }
        if (this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#subjectMap>") != null) {
            return (SubjectMapNode)this.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#subjectMap>");
        }
        return null;
    }

    public <T extends R2RMLNode> List<T> getPOMaps() {
        return this.getChildrenByPredicate("<http://www.w3.org/ns/r2rml#predicateObjectMap>");
    }

    @Override
    public String toString() {
        return BASE_LABEL;
    }
}

