/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.AbstractRDFActionDialog;

public class AddDatatypeIndexActionDialog
extends AbstractRDFActionDialog {
    private SqlComboBoxActionControl selectDatatype;
    private SqlComboBoxActionControl selectTablespace;
    private TextBoxActionControl txtDegreeParallelism = null;
    private TextBoxActionControl txtOptions = null;

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        String string = "SELECT column_value from TABLE( sys.odcivarchar2list('http://www.w3.org/2001/XMLSchema#decimal',\n'http://www.w3.org/2001/XMLSchema#string',\n'http://www.w3.org/2001/XMLSchema#time',\n'http://www.w3.org/2001/XMLSchema#date',\n'http://www.w3.org/2001/XMLSchema#dateTime',\n'http://xmlns.oracle.com/rdf/text',\n'http://xmlns.oracle.com/rdf/geo/WKTLiteral',\n'http://www.opengis.net/geosparql#wktLiteral'))";
        this.selectDatatype = new SqlComboBoxActionControl("datatype", RdfgraphArb.getString("AddDatatypeIndexActionDialog.DATATYPE"), connection, string, "");
        this.selectDatatype.enableEditBox();
        String string2 = "SELECT tablespace_name FROM user_tablespaces order by tablespace_name";
        this.selectTablespace = new SqlComboBoxActionControl("tablespace_name", RdfgraphArb.getString("TABLESPACE"), connection, string2, "");
        this.selectTablespace.enableEditBox();
        this.txtDegreeParallelism = new TextBoxActionControl("parallel", RdfgraphArb.getString("DEGREE_OF_PARALLELISM"), "1");
        this.txtOptions = new TextBoxActionControl("options", RdfgraphArb.getString("OPTIONS"), "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(AddDatatypeIndexActionDialog.this.txtNetworkOwner);
                this.add(AddDatatypeIndexActionDialog.this.txtNetworkName);
                this.add(AddDatatypeIndexActionDialog.this.selectDatatype);
                this.add(AddDatatypeIndexActionDialog.this.selectTablespace);
                this.add(AddDatatypeIndexActionDialog.this.txtDegreeParallelism);
                this.add(AddDatatypeIndexActionDialog.this.txtOptions);
            }
        };
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "ADD_DATATYPE_INDEX");
        string = this.updateScriptNetworkInfo(string, values);
        string = string.replaceAll("#datatype#", values.get("datatype"));
        string = string.replaceAll("#tablespace_name#", values.get("tablespace_name"));
        int n = 1;
        try {
            n = Integer.parseInt(values.get("parallel"));
        }
        catch (Exception exception) {
            n = 1;
        }
        string = string.replaceAll("#parallel#", "" + n);
        string = string.replaceAll("#options#", values.get("options"));
        return string;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("AddDatatypeIndexActionDialog.ADD_DATATYPE_INDEX");
    }
}

