/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.AbstractRDFActionDialog;

public class CreateSPARQLEndpointConfigDialog
extends AbstractRDFActionDialog {
    StringShuttleControl shtModels;
    StringShuttleControl shtRulebases;

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateSPARQLEndpointConfigDialog.this.txtNetworkOwner);
                this.add(CreateSPARQLEndpointConfigDialog.this.txtNetworkName);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        final ActionDialogTab actionDialogTab = new ActionDialogTab("models_in", RdfgraphArb.getString("MODELS")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        String string = "SELECT model_name from MDSYS.RDF_MODEL$";
                        if (!CreateSPARQLEndpointConfigDialog.this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
                            string = "SELECT model_name from " + CreateSPARQLEndpointConfigDialog.this.txtNetworkOwner.getValue().get() + "." + CreateSPARQLEndpointConfigDialog.this.txtNetworkName.getValue().get() + "#RDF_MODEL$";
                        }
                        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("MODEL_NAME")).collect(Collectors.toList());
                        CreateSPARQLEndpointConfigDialog.this.shtModels = new StringShuttleControl("models", "", list, Collections.emptyList());
                        this.add(CreateSPARQLEndpointConfigDialog.this.shtModels);
                    }
                };
                return arrayList;
            }
        };
        final ActionDialogTab actionDialogTab2 = new ActionDialogTab("rulebases_in", RdfgraphArb.getString("RULEBASES")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        String string = "SELECT RULEBASE_NAME from MDSYS.SEM_RULEBASE_INFO where STATUS='VALID'";
                        if (!CreateSPARQLEndpointConfigDialog.this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
                            string = "SELECT RULEBASE_NAME from " + CreateSPARQLEndpointConfigDialog.this.txtNetworkOwner.getValue().get() + "." + CreateSPARQLEndpointConfigDialog.this.txtNetworkName.getValue().get() + "#SEM_RULEBASE_INFO where STATUS='VALID'";
                        }
                        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("RULEBASE_NAME")).collect(Collectors.toList());
                        CreateSPARQLEndpointConfigDialog.this.shtRulebases = new StringShuttleControl("rulebases", "", list, Collections.emptyList());
                        this.add(CreateSPARQLEndpointConfigDialog.this.shtRulebases);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
                this.add(actionDialogTab2);
            }
        };
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        int n;
        String string = "";
        String string2 = "";
        List list = this.shtModels.getValue().getList("selected");
        List list2 = this.shtRulebases.getValue().getList("selected");
        if (list.size() <= 0) {
            return "--Please select at least one model";
        }
        string2 = (String)list.get(0);
        string = "--Replace the oracle:allGraphs section in your joseki-config.ttl\n";
        string = string + "--or config-oracle.ttl (Fuseki) configuration file with the following: \n";
        string = string + "oracle:allGraphs [ oracle:firstModel \"" + string2 + "\"; \n";
        for (n = 1; n < list.size(); ++n) {
            string = string + "                  oracle:modelName   \"" + (String)list.get(n) + "\";\n";
        }
        for (n = 0; n < list2.size(); ++n) {
            string = string + "                  oracle:rulebaseName   \"" + (String)list2.get(n) + "\";\n";
        }
        String string3 = values.get("network_owner");
        if (string3 != null && !"MDSYS".equalsIgnoreCase(string3)) {
            string = string + "                  oracle:networkOwner   \"" + string3 + "\";\n";
            string = string + "                  oracle:networkName   \"" + values.get("network_name") + "\";\n";
        }
        string = string + " ] .";
        return string;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateSPARQLEndpointConfigDialog.SPARQL_ENDPOINT_CONFIGURATION_FILE");
    }
}

