/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class CreateSemanticNetworkActionDialog
extends ActionDialog {
    private Connection connection;
    private String title;
    private SqlComboBoxActionControl selectNetworkOwner;
    private TextBoxActionControl txtSchema;
    private TextBoxActionControl txtNetworkName;
    private SqlComboBoxActionControl selectTablespace;
    private TextBoxActionControl txtMdsysNetwork;
    private boolean is19cOrAfter = false;
    private boolean isDBAschema = false;

    public void setTitle(String string) {
        this.title = string;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getDBVersion();
        this.is19cOrAfter = RDFStringUtils.isOracle19cOrAfter(string);
        String string2 = dBObject.getSchemaName();
        this.isDBAschema = this.isDBA(string2, connection);
        this.txtSchema = new TextBoxActionControl("schema", RdfgraphArb.getString("CreateSemanticNetworkActionDialog.NETWORK_OWNER"), string2);
        this.txtSchema.setEditable(false);
        String string3 = "SELECT username FROM all_users where username not like '%SYS%' order by username";
        this.selectNetworkOwner = new SqlComboBoxActionControl("network_owner", RdfgraphArb.getString("CreateSemanticNetworkActionDialog.NETWORK_OWNER"), connection, string3, "");
        this.selectNetworkOwner.enableEditBox();
        this.txtNetworkName = new TextBoxActionControl("network_name", RdfgraphArb.getString("CreateSemanticNetworkActionDialog.NETWORK_NAME"), "");
        String string4 = "SELECT tablespace_name FROM user_tablespaces order by tablespace_name";
        this.selectTablespace = new SqlComboBoxActionControl("tablespace_name", RdfgraphArb.getString("TABLESPACE"), connection, string4, "");
        this.selectTablespace.enableEditBox();
        this.txtMdsysNetwork = new TextBoxActionControl("mdsys_network", RdfgraphArb.getString("CreateSemanticNetworkActionDialog.NETWORK_OWNER"), "MDSYS");
        this.txtMdsysNetwork.setEditable(false);
        if (this.is19cOrAfter) {
            ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                {
                    if (CreateSemanticNetworkActionDialog.this.isDBAschema) {
                        this.add(CreateSemanticNetworkActionDialog.this.selectNetworkOwner);
                    } else {
                        this.add(CreateSemanticNetworkActionDialog.this.txtSchema);
                    }
                    this.add(CreateSemanticNetworkActionDialog.this.txtNetworkName);
                    this.add(CreateSemanticNetworkActionDialog.this.selectTablespace);
                }
            };
            return arrayList;
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateSemanticNetworkActionDialog.this.txtMdsysNetwork);
                this.add(CreateSemanticNetworkActionDialog.this.txtNetworkName);
                CreateSemanticNetworkActionDialog.this.txtNetworkName.setEditable(false);
                this.add(CreateSemanticNetworkActionDialog.this.selectTablespace);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){};
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDBA(String string, Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = "select * from user_role_privs where username = ? and granted_role in (?,?)";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string.toUpperCase());
            preparedStatement.setString(2, "DBA");
            preparedStatement.setString(3, "PDB_DBA");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_SEMANTIC_NETWORK");
        if (this.is19cOrAfter) {
            if (this.isDBAschema) {
                String string2 = values.get("network_owner");
                if (string2 == null || string2.trim().isEmpty()) {
                    string = string.replaceAll("#network_owner#", "'MDSYS'");
                    string = string.replaceAll("#network_name#", "null");
                } else {
                    string = string.replaceAll("#network_owner#", "'" + values.get("network_owner") + "'");
                    string = string.replaceAll("#network_name#", "'" + values.get("network_name") + "'");
                }
            } else {
                string = string.replaceAll("#network_owner#", "'" + values.get("schema") + "'");
                string = string.replaceAll("#network_name#", "'" + values.get("network_name") + "'");
            }
        }
        string = string.replaceAll("#tablespace_name#", values.get("tablespace_name"));
        return string;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateSemanticNetworkActionDialog.CREATE_SEMANTIC_NETWORK");
    }

    protected String getHelpId() {
        return "rdfplugin-intro__GUID-CF6869CF-9C5F-4448-823C-29B9D0A164EA";
    }
}

