/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.classpath.ClasspathTree;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitResult;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitor;
import oracle.jdeveloper.java.classpath.JavaTypeVisitor;
import oracle.jdeveloper.java.classpath.ResourceVisitor;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;

public abstract class BaseClassLocator
implements JavaClassLocator2,
JavaResourceLocator,
ClasspathTree {
    @CodeSharingSafe(value="StaticField")
    public static final BaseClassLocator EMPTY_LOCATOR = new NOPClassLocator();
    private boolean containsModuleClasses;
    @CodeSharingSafe(value="StaticField")
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    @CodeSharingSafe(value="StaticField")
    public static final Collection EMPTY_COLLECTION = Arrays.asList(EMPTY_STRING_ARRAY);
    private static SimpleCache _splitNameCache = new SimpleCache(25);

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this.buildIndex();
    }

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        URL url = this.getResourceURL(resourceName);
        if (url == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> ret = new ArrayList<URL>(1);
        ret.add(url);
        return ret;
    }

    @Override
    public Collection<String> getPackages(String packagePrefix) {
        ArraySortedSet packageSet = new ArraySortedSet(20);
        this.getPackages(packagePrefix, (Collection<String>)packageSet);
        return packageSet;
    }

    @Override
    public Collection<String> getPackagesInterruptibly(String packagePrefix) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet(20);
        this.getPackagesInterruptibly(packagePrefix, (Collection<String>)packageSet);
        return packageSet;
    }

    public abstract void getPackages(String var1, Collection<String> var2);

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getPackages(packagePrefix, out);
    }

    @Override
    public Collection<String> getClassesInPackage(String packagePrefix) {
        ArraySortedSet classSet = new ArraySortedSet(100);
        this.getClassesInPackage(packagePrefix, (Collection<String>)classSet);
        return classSet;
    }

    @Override
    public Collection<String> getClassesInPackageInterruptibly(String packagePrefix) throws InterruptedException {
        ArraySortedSet classSet = new ArraySortedSet(100);
        this.getClassesInPackageInterruptibly(packagePrefix, (Collection<String>)classSet);
        return classSet;
    }

    public abstract void getClassesInPackage(String var1, Collection<String> var2);

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getClassesInPackage(packagePrefix, out);
    }

    @Override
    public Collection<String> getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public Collection<String> getAllClassesInterruptibly() throws InterruptedException {
        return this.getAllClassesInterruptibly(null);
    }

    @Override
    public Collection<String> getAllClasses(ClassNameFilter filter) {
        HashSet<String> hashSet = new HashSet<String>(10000);
        this.getAllClasses(hashSet, filter);
        return hashSet;
    }

    @Override
    public Collection<String> getAllClassesInterruptibly(ClassNameFilter filter) throws InterruptedException {
        HashSet<String> hashSet = new HashSet<String>(10000);
        this.getAllClassesInterruptibly(hashSet, filter);
        return hashSet;
    }

    public abstract void getAllClasses(Collection<String> var1, ClassNameFilter var2);

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getAllClasses(out, filter);
    }

    protected Collection<String> getClassesDirectly() {
        return Collections.emptySet();
    }

    protected Collection<URL> getResourcesDirectly(String name) {
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getAllPackages() {
        return this.getAllPackages(null);
    }

    @Override
    public Collection<String> getAllPackagesInterruptibly() throws InterruptedException {
        return this.getAllPackagesInterruptibly(null);
    }

    @Override
    public Collection<String> getAllPackages(PackageNameFilter filter) {
        ArraySortedSet packageSet = new ArraySortedSet(200);
        this.getAllPackages((Collection<String>)packageSet, filter);
        return packageSet;
    }

    @Override
    public Collection<String> getAllPackagesInterruptibly(PackageNameFilter filter) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet(200);
        this.getAllPackagesInterruptibly((Collection<String>)packageSet, filter);
        return packageSet;
    }

    public abstract void getAllPackages(Collection<String> var1, PackageNameFilter var2);

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.getAllPackages(out, filter);
    }

    @Override
    public Collection<String> getClassesByName(String name, boolean matchCase) {
        SimpleNameFilter wholeNameFilter = new SimpleNameFilter(name, matchCase, 1);
        return this.getAllClasses(wholeNameFilter);
    }

    @Override
    public Collection<String> getClassesByNameInterruptibly(String name, boolean matchCase) throws InterruptedException {
        SimpleNameFilter wholeNameFilter = new SimpleNameFilter(name, matchCase, 1);
        return this.getAllClassesInterruptibly(wholeNameFilter);
    }

    @Override
    public Collection<String> getClassesByPrefix(String prefix, boolean matchCase) {
        SimpleNameFilter prefixFilter = new SimpleNameFilter(prefix, matchCase, 2);
        return this.getAllClasses(prefixFilter);
    }

    @Override
    public Collection<String> getClassesByPrefixInterruptibly(String prefix, boolean matchCase) throws InterruptedException {
        SimpleNameFilter prefixFilter = new SimpleNameFilter(prefix, matchCase, 2);
        return this.getAllClassesInterruptibly(prefixFilter);
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getURL(fqClassName);
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getSourceURL(fqClassName);
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getClassURL(fqClassName);
    }

    protected Object getClasspathTreeNode() {
        return null;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        return Collections.emptySet();
    }

    protected BaseClassLocator getSourceLocator(BaseClassLocator locator) {
        return null;
    }

    @Override
    public final void visitClasspathTree(ClasspathTreeVisitor visitor) {
        this.visitClasspathTree(visitor, EnumSet.noneOf(ClasspathTreeVisitOptions.class));
    }

    @Override
    public final void visitClasspathTree(ClasspathTreeVisitor visitor, EnumSet<ClasspathTreeVisitOptions> options) {
        ClasspathTreeVisitResult result = this.visitClasspathTree(visitor, options, new TreeVisitorFunction());
        if (result == null) {
            throw new NullPointerException("visitor returned null");
        }
    }

    private final <T extends ClasspathTreeVisitor> ClasspathTreeVisitResult visitClasspathTree(ClasspathTreeVisitor visitor, EnumSet<ClasspathTreeVisitOptions> options, VisitorFunction<T> function) {
        return this.visitClasspathTree(visitor, options, function, new Stack<BaseClassLocator>());
    }

    private final <T extends ClasspathTreeVisitor> ClasspathTreeVisitResult visitClasspathTree(ClasspathTreeVisitor visitor, EnumSet<ClasspathTreeVisitOptions> options, VisitorFunction<T> function, Stack<BaseClassLocator> stack) {
        ClasspathTreeVisitResult result;
        Object node = this.getClasspathTreeNode();
        if (node != null && (result = visitor.preVisitSubtree(node)) != ClasspathTreeVisitResult.CONTINUE) {
            return result;
        }
        stack.push(this);
        result = function.visit(visitor, this, stack);
        if (result == null || result == ClasspathTreeVisitResult.TERMINATE) {
            return result;
        }
        for (BaseClassLocator child : this.getChildLocators(options)) {
            result = child.visitClasspathTree(visitor, options, function, stack);
            if (result != null && result != ClasspathTreeVisitResult.TERMINATE) continue;
            return result;
        }
        stack.pop();
        return node == null ? ClasspathTreeVisitResult.CONTINUE : visitor.postVisitSubtree(node);
    }

    @Override
    public final void visitJavaTypes(JavaTypeVisitor visitor) {
        this.visitJavaTypes(visitor, EnumSet.noneOf(ClasspathTreeVisitOptions.class));
    }

    @Override
    public final void visitJavaTypes(JavaTypeVisitor visitor, EnumSet<ClasspathTreeVisitOptions> options) {
        ClasspathTreeVisitResult result = this.visitClasspathTree(visitor, options, new JavaTypeVisitorFunction());
        if (result == null) {
            throw new NullPointerException("visitor returned null");
        }
    }

    @Override
    public final void visitResources(String name, ResourceVisitor visitor) {
        this.visitResources(name, visitor, EnumSet.noneOf(ClasspathTreeVisitOptions.class));
    }

    @Override
    public final void visitResources(String name, ResourceVisitor visitor, EnumSet<ClasspathTreeVisitOptions> options) {
        ClasspathTreeVisitResult result = this.visitClasspathTree(visitor, options, new ResourceVisitorFunction(name));
        if (result == null) {
            throw new NullPointerException("visitor returned null");
        }
    }

    public void setContainsModuleClasses(boolean containsModuleClasses) {
        this.containsModuleClasses = containsModuleClasses;
    }

    protected boolean getContainsModuleClasses() {
        return this.containsModuleClasses;
    }

    protected static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected static BaseClassLocator ensureValid(BaseClassLocator locator) {
        if (locator != null) {
            return locator;
        }
        return EMPTY_LOCATOR;
    }

    public static <T> void addToCollection(T[] array, Collection<T> collection) {
        collection.addAll(Arrays.asList(array));
    }

    public static String[] getStringArray(Collection<String> collection) {
        int size = collection == null ? 0 : collection.size();
        return size == 0 ? EMPTY_STRING_ARRAY : collection.toArray(new String[size]);
    }

    public static String buildFQName(String packagePrefix, String className) {
        String fullName = packagePrefix.length() > 0 ? packagePrefix + "." + className : className;
        return fullName;
    }

    protected static String[] getNameParts(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return splitName._nameParts;
    }

    protected static String[] getNameCascades(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return splitName._nameCascades;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplitName getSplitName(String fqName) {
        SimpleCache simpleCache = _splitNameCache;
        synchronized (simpleCache) {
            SplitName splitName = (SplitName)BaseClassLocator._splitNameCache.get(fqName);
            if (splitName == null) {
                splitName = new SplitName(fqName);
                BaseClassLocator._splitNameCache.put(fqName, splitName);
            }
            return splitName;
        }
    }

    private static class JavaTypeImpl
    implements JavaTypeVisitor.JavaType {
        private final BaseClassLocator classLocator;
        private final BaseClassLocator sourceLocator;
        private final String name;

        public JavaTypeImpl(BaseClassLocator classLocator, BaseClassLocator sourceLocator, String name) {
            this.classLocator = classLocator;
            this.sourceLocator = sourceLocator;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public URL getClassURL() {
            return this.classLocator.getClassURL(this.getName());
        }

        @Override
        public URL getSourceURL() {
            return this.sourceLocator.getSourceURL(this.getName());
        }
    }

    private static class NOPClassLocator
    extends BaseClassLocator {
        private NOPClassLocator() {
        }

        @Override
        public void buildIndex() {
        }

        @Override
        public void getPackages(String packagePrefix, Collection<String> out) {
        }

        @Override
        public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        }

        @Override
        public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        }

        @Override
        public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        }

        @Override
        public URL getURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getSourceURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getClassURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getResourceURL(String resourceName) {
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String resourceName) {
            return Collections.emptyList();
        }
    }

    private static class SplitName {
        private String[] _nameParts;
        private String[] _nameCascades;

        private SplitName(String fqName) {
            int lastDot;
            int i;
            int numDots = 0;
            int nameLength = fqName.length();
            for (i = 0; i < nameLength; ++i) {
                if (fqName.charAt(i) != '.') continue;
                ++numDots;
            }
            this._nameParts = new String[numDots + 1];
            this._nameCascades = new String[numDots + 1];
            this._nameCascades[numDots] = fqName;
            for (i = numDots - 1; i >= 0; --i) {
                String longerCascade = this._nameCascades[i + 1];
                lastDot = longerCascade.lastIndexOf(46);
                this._nameCascades[i] = longerCascade.substring(0, lastDot);
            }
            for (i = 0; i <= numDots; ++i) {
                String cascade = this._nameCascades[i];
                lastDot = cascade.lastIndexOf(46);
                this._nameParts[i] = lastDot == -1 ? cascade : cascade.substring(lastDot + 1);
            }
        }
    }

    private static class SimpleCache {
        private int _maxSize;
        private ArrayList _entryList;
        private HashMap _entryMap;

        private SimpleCache(int maxSize) {
            this._maxSize = maxSize;
            this._entryList = new ArrayList(maxSize + 1);
            this._entryMap = new HashMap(maxSize + 1);
        }

        private Object get(String key) {
            return this._entryMap.get(key);
        }

        private void put(String key, Object value) {
            this._entryMap.put(key, value);
            this._entryList.add(key);
            if (this._entryList.size() > this._maxSize) {
                String oldestKey = (String)this._entryList.remove(0);
                this._entryMap.remove(oldestKey);
            }
        }
    }

    private static final class ResourceVisitorFunction
    implements VisitorFunction<ResourceVisitor> {
        private final String name;

        public ResourceVisitorFunction(String name) {
            this.name = name;
        }

        @Override
        public ClasspathTreeVisitResult visit(ResourceVisitor visitor, BaseClassLocator locator, Stack<BaseClassLocator> stack) {
            Collection<URL> resources = locator.getResourcesDirectly(this.name);
            if (!resources.isEmpty()) {
                return visitor.visitResources(resources);
            }
            return ClasspathTreeVisitResult.CONTINUE;
        }
    }

    private static final class JavaTypeVisitorFunction
    implements VisitorFunction<JavaTypeVisitor> {
        private JavaTypeVisitorFunction() {
        }

        @Override
        public ClasspathTreeVisitResult visit(JavaTypeVisitor visitor, BaseClassLocator locator, Stack<BaseClassLocator> stack) {
            Collection<String> typeNames = locator.getClassesDirectly();
            if (!typeNames.isEmpty()) {
                BaseClassLocator child;
                BaseClassLocator parent;
                BaseClassLocator sourceLocator = null;
                for (int i = stack.size() - 1; i > 0 && (sourceLocator = (parent = (BaseClassLocator)stack.get(i - 1)).getSourceLocator(child = (BaseClassLocator)stack.get(i))) == null; --i) {
                }
                ArrayList<JavaTypeVisitor.JavaType> types = new ArrayList<JavaTypeVisitor.JavaType>(typeNames.size());
                for (String name : typeNames) {
                    types.add(new JavaTypeImpl(locator, sourceLocator == null ? locator : sourceLocator, name));
                }
                return visitor.visitJavaTypes(types);
            }
            return ClasspathTreeVisitResult.CONTINUE;
        }
    }

    private static final class TreeVisitorFunction
    implements VisitorFunction<ClasspathTreeVisitor> {
        private TreeVisitorFunction() {
        }

        @Override
        public ClasspathTreeVisitResult visit(ClasspathTreeVisitor visitor, BaseClassLocator locator, Stack<BaseClassLocator> stack) {
            return ClasspathTreeVisitResult.CONTINUE;
        }
    }

    private static interface VisitorFunction<T extends ClasspathTreeVisitor> {
        public ClasspathTreeVisitResult visit(T var1, BaseClassLocator var2, Stack<BaseClassLocator> var3);
    }
}

