/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class PackageEntry {
    URL _packageURL;
    long _lastModified;
    String _packageName;
    private String[] _classNames;
    private String[] _subPackageNames;

    PackageEntry(URL packageURL, List<String> classNames, List<String> subPackageNames, long lastModified) {
        this._packageName = null;
        this._packageURL = packageURL;
        this._lastModified = lastModified;
        this.initData(classNames, subPackageNames);
    }

    PackageEntry(String packageName, Collection<String> classNames, Collection<String> subPackageNames) {
        this._packageName = packageName;
        this._packageURL = null;
        this._lastModified = -1L;
        this.initData(classNames, subPackageNames);
    }

    private void initData(Collection<String> classNames, Collection<String> subPackageNames) {
        if (classNames == null) {
            this._classNames = new String[0];
        } else {
            this._classNames = classNames.toArray(new String[classNames.size()]);
            Arrays.sort(this._classNames);
        }
        if (subPackageNames == null) {
            this._subPackageNames = new String[0];
        } else {
            this._subPackageNames = subPackageNames.toArray(new String[subPackageNames.size()]);
            Arrays.sort(this._subPackageNames);
        }
    }

    protected void setClasses(String[] classNames, boolean sort) {
        if (classNames == null) {
            this._classNames = new String[0];
        } else {
            this._classNames = classNames;
            if (sort) {
                Arrays.sort(this._classNames);
            }
        }
    }

    String[] getClasses() {
        return this._classNames;
    }

    void getClasses(Collection<String> out) {
        for (String className : this._classNames) {
            out.add(className);
        }
    }

    void getTopLevelClasses(Collection<String> out) {
        for (String className : this._classNames) {
            if (className.indexOf(36) >= 0) continue;
            out.add(className);
        }
    }

    boolean containsClass(String name) {
        return Arrays.binarySearch(this._classNames, name) >= 0;
    }

    String[] getSubpackageNames() {
        return this._subPackageNames;
    }

    void getSubpackageNames(Collection<String> out) {
        for (String subPackageName : this._subPackageNames) {
            out.add(subPackageName);
        }
    }

    boolean containsSubPackage(String name) {
        return Arrays.binarySearch(this._subPackageNames, name) >= 0;
    }
}

