/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori.DB2;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

public class HarvestDoc {
    private static String urlPrefix = "https://www.ibm.com/support/knowledgecenter/SSEPGG_11.1.0/com.ibm.db2.luw.sql.ref.doc/doc/";
    private static Set<String> processed = new HashSet<String>();
    static Map<String, ParseNode> allStatements = new HashMap<String, ParseNode>();

    public static void main(String[] stringArray) throws Exception {
        HarvestDoc.crawlDocWebsite();
        System.out.println("Total Statements = " + allStatements.size());
        int n = 0;
        for (String string : allStatements.keySet()) {
            if (HarvestDoc.allStatements.get((Object)string).topLevel != null || 0 >= allStatements.get(string).children().size()) continue;
            ++n;
        }
        System.out.println("Parsed = " + n);
    }

    private static void crawlDocWebsite() {
        String string;
        block3: {
            processed = new HashSet<String>();
            string = null;
            try {
                string = HarvestDoc.readURL(urlPrefix + "r0011049.html?view=embed");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("\nFileNotFoundException " + fileNotFoundException.getMessage());
                System.exit(0);
            }
            catch (Exception exception) {
                if (!exception.getClass().getPackage().getName().contains("java.net")) break block3;
                System.err.println("Failed to connect to " + exception.getMessage());
                System.exit(0);
            }
        }
        HarvestDoc.processReferences(string);
    }

    private static void processReferences(String string) {
        String string2;
        int n;
        String string3 = "<a class=\"xref\" href=\"";
        String string4 = "\" title=\"";
        int n2 = string.indexOf(string3);
        while (n2 > 0 && (n = string.indexOf(string4, n2 + string3.length())) >= 0) {
            if (n2 + string3.length() + 20 >= n) {
                string2 = string.substring(n2 + string3.length(), n);
                if (string2.startsWith("../doc/")) {
                    string2 = string2.substring("../doc/".length());
                }
                if (!string2.contains("/")) {
                    try {
                        if ("r0061970.html".equals(string2)) {
                            string2 = string2 + "";
                        }
                        HarvestDoc.processDoc(string2);
                    }
                    catch (Exception exception) {
                        System.err.println(string2 + " " + exception.getMessage() + " ");
                    }
                }
            }
            n2 = string.indexOf(string3, n2 + string3.length());
        }
        string3 = "<a class=\"link\" href=\"";
        string4 = "\">";
        n2 = string.indexOf(string3);
        while (n2 > 0 && (n = string.indexOf(string4, n2 + string3.length())) >= 0) {
            if (n2 + string3.length() + 20 >= n) {
                string2 = string.substring(n2 + string3.length(), n);
                if (string2.startsWith("../doc/")) {
                    string2 = string2.substring("../doc/".length());
                }
                if (!string2.contains("/")) {
                    try {
                        if ("r0061970.html".equals(string2)) {
                            string2 = string2 + "";
                        }
                        HarvestDoc.processDoc(string2);
                    }
                    catch (Exception exception) {
                        System.err.println(string2 + " " + exception.getMessage() + " ");
                    }
                }
            }
            n2 = string.indexOf(string3, n2 + string3.length());
        }
    }

    private static void processDoc(String string) throws FileNotFoundException, IOException {
        String string2;
        String string3;
        block8: {
            string3 = null;
            try {
                string2 = urlPrefix + string + "?view=embed";
                if (processed.contains(string2)) {
                    return;
                }
                processed.add(string2);
                string3 = HarvestDoc.readURL(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("\nFileNotFoundException " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                if (!exception.getClass().getPackage().getName().contains("java.net")) break block8;
                System.err.println("URL=" + string);
                System.err.println("Failed to connect to " + exception.getMessage());
                System.exit(0);
            }
        }
        string2 = "<code>";
        String string4 = "</code>";
        int n = string3.indexOf(string2);
        while (n > 0) {
            int n2 = string3.indexOf(string4, n + string2.length());
            String string5 = string3.substring(n + string2.length(), n2);
            string5 = string5.replace("&gt;", ">");
            string5 = string5.replace("&lt;", "<");
            string5 = string5.replace("<strong class=\"ph b\">", "");
            string5 = string5.replace("</strong>", "");
            string5 = string5.replace("<em class=\"ph i\">", "");
            if (!((string5 = string5.replace("</em>", "")).startsWith("<storage") || string5.startsWith("NAME") || string5.startsWith("123") || allStatements.containsKey(string5))) {
                List list = LexerToken.parse((String)string5);
                ParseNode parseNode = SqlEarley.getInstance().parse(list);
                allStatements.put(string5, parseNode);
                if (parseNode.topLevel != null || parseNode.children().size() == 0) {
                    System.err.println(string5);
                } else {
                    System.out.println(string5);
                }
                System.out.println("------------------------------");
            }
            n = string3.indexOf(string2, n + string2.length());
        }
        HarvestDoc.processReferences(string3);
    }

    static String readURL(String string) throws Exception {
        if (string.endsWith(".pdf") || string.endsWith(".mobi") || string.endsWith(".epub")) {
            return "";
        }
        byte[] byArray = new byte[4096];
        int n = 0;
        URL uRL = new URL(string);
        System.out.print("opening " + string + "...");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        System.out.println("done.");
        n = bufferedInputStream.read(byArray, 0, byArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        while (n != -1) {
            stringBuilder.append(new String(byArray).substring(0, n));
            n = bufferedInputStream.read(byArray, 0, byArray.length);
        }
        bufferedInputStream.close();
        return stringBuilder.toString();
    }
}

