/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori.TSQL;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.PlsqlRules;
import oracle.dbtools.util.Service;

public class TsqlRules {
    private static final String fname = "TsqlBNF.serial";
    private static final String path = "/oracle/dbtools/arbori/";

    public static void main(String[] stringArray) throws Exception {
        TsqlRules.memorizeRules();
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> set = TsqlRules.parseBNFtext(TsqlRules.readBNFfile());
        String string = Service.readFile(TsqlRules.class, (String)"TsqlFixes.grammar");
        List list = LexerToken.parse((String)string, (boolean)false, (int)1);
        ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
        Grammar.grammar((ParseNode)parseNode, (List)list, set);
        TsqlRules.substitute(set, "alt_ty_attr_list", "\"alt_ty_attr_list\"");
        RuleTransforms.eliminateEmptyProductions(set);
        RuleTransforms.substituteSingleUnaryProductions(set);
        RuleTuple.printRules(set);
        FileOutputStream fileOutputStream = new FileOutputStream("utils/src/oracle/dbtools/arbori/TsqlBNF.serial");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
        RuleTuple.printRules(set);
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL uRL = PlsqlRules.class.getResource("/oracle/dbtools/arbori/TsqlBNF.serial");
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    public static Set<RuleTuple> parseBNFtext(String string) throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        LexerToken.switchLineCommentSymbol((String)"/");
        List list = LexerToken.parse((String)string, (boolean)true, (int)1);
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        for (int i = 0; i < list.size(); ++i) {
            LexerToken lexerToken = (LexerToken)list.get(i);
            if (lexerToken.type == Token.WS || lexerToken.type == Token.LINE_COMMENT || lexerToken.type == Token.COMMENT) continue;
            try {
                LexerToken lexerToken2 = (LexerToken)list.get(i + 1);
                LexerToken lexerToken3 = (LexerToken)list.get(i + 2);
                if (":".equals(lexerToken2.content) && lexerToken3.type != Token.WS || ":".equals(lexerToken.content) && lexerToken2.type != Token.WS) {
                    continue;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (lexerToken.type == Token.IDENTIFIER && lexerToken.content.toUpperCase().equals(lexerToken.content)) {
                lexerToken.content = "'" + lexerToken.content.toUpperCase() + "'";
            }
            arrayList.add(lexerToken);
        }
        ParseNode parseNode = Grammar.parseGrammarFile(arrayList, (String)string);
        Grammar.grammar((ParseNode)parseNode, arrayList, treeSet);
        return treeSet;
    }

    private static void substitute(Set<RuleTuple> set, String string, String string2) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
        boolean bl = false;
        for (RuleTuple ruleTuple : set) {
            RuleTuple ruleTuple2 = new RuleTuple(ruleTuple.head, new String[ruleTuple.rhs.length]);
            if (ruleTuple.head.equals(string)) {
                ruleTuple2.head = string2;
                bl = true;
            }
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (ruleTuple.rhs[i].equals(string)) {
                    ruleTuple2.rhs[i] = string2;
                    bl = true;
                    continue;
                }
                ruleTuple2.rhs[i] = ruleTuple.rhs[i];
            }
            if (!bl) continue;
            treeSet.add(ruleTuple);
            treeSet2.add(ruleTuple2);
        }
        set.removeAll(treeSet);
        set.addAll(treeSet2);
    }

    public static Set<String> getKeywords(Set<RuleTuple> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RuleTuple ruleTuple : set) {
            for (String string : ruleTuple.rhs) {
                if (!string.startsWith("'")) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    static String readBNFfile() throws Exception {
        String string = Service.readFile((String)"/raptor_trunk/migrations/translator_core/antlr/oracle/dbtools/migration/parser/grammar/TSQLRecognizer.g");
        String string2 = "// starting rule";
        string = string.substring(string.indexOf(string2) + string2.length());
        string = TsqlRules.removeNestedBlock(string, "/*", "*/");
        string = TsqlRules.removeNestedBlock(string, "{", "}?");
        string = TsqlRules.removeNestedBlock(string, "{", "}");
        string = TsqlRules.removeNestedBlock(string, "{", "}");
        string = TsqlRules.removeNestedBlock(string, "{", "}");
        string = TsqlRules.removeNestedBlock(string, "{", "}");
        string = TsqlRules.removeNestedBlock(string, "keyword:", "TSQL_KEYWORD_START\r\n;");
        string = string.replace("hexliteral:HEXLITERAL", "hexliteral : HEXLITERAL");
        string = string.replace("DOT", "'.'");
        string = string.replace("COLON", "':'");
        string = string.replace("SEMICOLON", "';'");
        string = string.replace("COMMA", "','");
        string = string.replace("LPAREN", "'('");
        string = string.replace("RPAREN", "')'");
        string = string.replace("PLUS", "'+'");
        string = string.replace("MINUS", "'-'");
        string = string.replace("TILDE", "'~'");
        string = string.replace("!", "");
        string = string.replace("^", "");
        return string;
    }

    static String removeNestedBlock(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < string.length()) {
            n3 = string.indexOf(string2, n4);
            int n5 = string.indexOf(string2, n3 + n);
            int n6 = string.indexOf(string3, n3 + n) + n2;
            if (n3 > 0 && n3 < n5 && n5 < n6) {
                stringBuffer.append(string.substring(n4, n3 + n));
                n4 = n3 + n;
                continue;
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            stringBuffer.append(string.substring(n4, n3));
            n4 = string.indexOf(string3, n3 + n) + n2;
            if (n4 >= n2) continue;
            stringBuffer.append(string.substring(n3));
            break;
        }
        return stringBuffer.toString();
    }
}

