/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.dbtools.raptor.UtilResources;
import oracle.dbtools.raptor.utils.JawsUtil;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.view.View;

public class ViewUtil {
    private static final Class<?> clazz = ViewUtil.class;

    public static void activateView(View view) throws UnsupportedOperationException {
        if (view instanceof Dockable) {
            Dockable dockable = (Dockable)view;
            DockStation dockStation = DockStation.getDockStation();
            dockStation.setDockableVisible(dockable, true);
            dockStation.activateDockable(dockable);
        } else if (view instanceof Editor) {
            Editor editor = (Editor)view;
            EditorManager editorManager = EditorManager.getEditorManager();
            List list = editorManager.getEditorsInfo();
            for (EditorInfo editorInfo : list) {
                if (!editor.equals(editorInfo._getEditor())) continue;
                editorManager.activateEditor(editorInfo);
                break;
            }
        } else if (view instanceof AbstractLogPage) {
            ((AbstractLogPage)view).show();
        } else {
            throw new UnsupportedOperationException(ViewUtil.getNameForView(view));
        }
    }

    public static Action getActivateViewAction(final View view) {
        final String string = ViewUtil.getNameForView(view);
        AbstractAction abstractAction = new AbstractAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ViewUtil.activateView(view);
                }
                catch (Throwable throwable) {
                    String string2 = UtilResources.format("ViewUtil.ACTIVATE_VIEW_FAIL", string);
                    Logger.severe((Class)clazz, (String)string2, (Throwable)throwable);
                    JawsUtil.forceJaws(string2);
                }
            }
        };
        abstractAction.putValue("MnemonicKey", KeyEvent.getExtendedKeyCodeForChar(string.charAt(0)));
        return abstractAction;
    }

    public static List<View> getActiveViews() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        ArrayList<View> arrayList = new ArrayList<View>(ideMainWindow.getVisibleViews());
        List list = EditorManager.getEditorManager().getAllEditors();
        LogPage[] logPageArray = list.iterator();
        while (logPageArray.hasNext()) {
            LogPage[] logPageArray2 = (LogPage[])logPageArray.next();
            if (arrayList.contains(logPageArray2)) continue;
            arrayList.add((View)logPageArray2);
        }
        for (LogPage logPage : logPageArray = LogManager.getLogManager().getPages()) {
            if (!(logPage instanceof View) || arrayList.contains((View)logPage)) continue;
            arrayList.add((View)logPage);
        }
        arrayList.remove(Ide.getMainWindow().getIdeMainWindowView());
        arrayList.remove(LogManager.getLogManager().getLogWindow());
        Collections.sort(arrayList, Comparator.comparing(view -> ViewUtil.getNameForView(view)));
        return arrayList;
    }

    public static String getNameForView(View view) {
        Dockable dockable;
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (view instanceof Dockable) {
            dockable = (Dockable)view;
            try {
                string2 = dockable.getTitleName();
                hashMap.put("Dockable Title Name", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
            try {
                string2 = dockable.getTabName();
                hashMap.put("Dockable Tab Name", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
            try {
                string2 = dockable.getMenuTitle();
                hashMap.put("Dockable Menu Title", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
        }
        if (view instanceof Editor) {
            dockable = (Editor)view;
            try {
                string2 = dockable.getTabLabel();
                hashMap.put("Editor Tab Label", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
            try {
                string2 = dockable.getTitleLabel();
                hashMap.put("Editor Title Label", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
            try {
                string2 = dockable.getEditorAddin().getMenuSpecification().label;
                hashMap.put("Editor Addin Menuspec Label", string2);
                if (null == string || string.isEmpty()) {
                    string = string2;
                } else if (string2 != null && !string2.isEmpty() && !string2.equals(string)) {
                    string = string + ' ' + string2;
                }
            }
            catch (Throwable throwable) {
                Logger.ignore(clazz, (Throwable)throwable);
            }
        }
        try {
            string2 = view.getTabName();
            hashMap.put("View Tab Name", string2);
            if (null == string || string.isEmpty()) {
                string = string2;
            }
        }
        catch (Throwable throwable) {
            Logger.ignore(clazz, (Throwable)throwable);
        }
        try {
            string2 = String.valueOf(view);
            hashMap.put("String.valueOf(view)", string2);
            if (null == string || string.isEmpty()) {
                string = string2;
            }
        }
        catch (Throwable throwable) {
            Logger.ignore(clazz, (Throwable)throwable);
        }
        return string;
    }
}

