/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class SqlLocator {
    static final SqlEarley earley = SqlEarley.getInstance();

    public static long locate(int n, String string) {
        List list = LexerToken.parse((String)string);
        int n2 = LexerToken.scanner2parserOffset((List)list, (int)n);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(list, (Matriceable)matrix);
        long l = SqlLocator.getStatement(list, matrix, n2);
        long l2 = Service.lPair((int)0, (int)string.length());
        if (l != -1L) {
            l2 = Service.lPair((int)((LexerToken)list.get((int)Service.lX((long)l))).begin, (int)((LexerToken)list.get((int)(Service.lY((long)l) - 1))).end);
        } else {
            Logger.getLogger(SqlLocator.class.getName()).log(Level.WARNING, "SqlLocator.getStatement() failed");
            int n3 = 0;
            int n4 = string.length();
            for (LexerToken lexerToken : list) {
                if (!";".equals(lexerToken.content)) continue;
                if (lexerToken.begin < n) {
                    n3 = lexerToken.end;
                }
                if (n >= lexerToken.end) continue;
                n4 = lexerToken.begin;
                break;
            }
            l2 = Service.lPair((int)n3, (int)n4);
        }
        return l2;
    }

    private static long getStatement(List<LexerToken> list, Matrix matrix, int n) {
        int n2 = SqlEarley.getInstance().getSymbol("sql_statement");
        int n3 = SqlEarley.getInstance().getSymbol("sql_stmt");
        int n4 = 0;
        int n5 = matrix.lastY();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                long[] lArray;
                Cell cell;
                int n6 = n4 + j;
                int n7 = n5 + j - i;
                if (n < n6 || n7 <= n || (cell = matrix.get(n6, n7)) == null) continue;
                for (long l : lArray = cell.getContent()) {
                    int n8 = Earley.ruleFromEarleyCell((long)l);
                    Parser.Tuple tuple = SqlEarley.getInstance().rules[n8];
                    if (tuple.head != n2 && tuple.head != n3) continue;
                    return Service.lPair((int)n6, (int)n7);
                }
            }
        }
        return -1L;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile((String)"/EclipseWorkspace/common/common/src/oracle/dbtools/parser/plsql/test.sql");
        List list = LexerToken.parse((String)string);
        int n = 2;
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(list, (Matriceable)matrix);
        long l = SqlLocator.getStatement(list, matrix, n);
        if (l > -1L) {
            System.out.println(string.substring(((LexerToken)list.get((int)Service.lX((long)l))).begin, ((LexerToken)list.get((int)(Service.lY((long)l) - 1))).end));
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        n = 46;
        for (LexerToken lexerToken : list) {
            if (!";".equals(lexerToken.content)) continue;
            if (lexerToken.begin < n) {
                n2 = lexerToken.end;
            }
            if (n >= lexerToken.end) continue;
            n3 = lexerToken.begin;
            break;
        }
        System.out.println(string.substring(n2, n3));
    }

    public static String extractStmt(int n, String string, String string2) {
        if (0 < n) {
            long l = SqlLocator.locate(n, string);
            string = string.substring(Service.lX((long)l), Service.lY((long)l));
        }
        if ((string = string.trim()).endsWith("/") && !string.endsWith("*/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
            string = string.substring(0, string.length() - 1);
        }
        string = SqlLocator.addHint(string, string2);
        return string;
    }

    private static String addHint(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        List list = LexerToken.parse((String)string);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            LexerToken lexerToken = (LexerToken)iterator.next();
            if ("select".equalsIgnoreCase(lexerToken.content)) {
                return lexerToken.content + " /*+ " + string2 + " */ " + string.substring(lexerToken.end);
            }
            return string;
        }
        return string;
    }
}

