/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import net.jcip.annotations.GuardedBy;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.MetaClassList;
import oracle.ide.index.IndexingListener;
import oracle.ideimpl.index.extension.IndexerInfo;
import oracle.ideimpl.index.extension.IndexingInfoConstants;
import oracle.ideimpl.index.extension.IndexingInfoListener;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.NullArgumentException;

public class IndexingInfo
implements IndexingInfoConstants {
    private static final ElementName INDEXING_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "indexing-hook");
    private static final IndexingInfo INSTANCE = new IndexingInfo();
    @GuardedBy(value="itself")
    private final List<IndexerInfo> indexers = new ArrayList<IndexerInfo>();
    @GuardedBy(value="indexers")
    private final CopyOnWriteArrayList<IndexingInfoListener> indexerListeners = new CopyOnWriteArrayList();
    private final MetaClassList<IndexingListener> listeners;

    public static IndexingInfo getInstance() {
        return INSTANCE;
    }

    private static List<IndexerInfo> getIndexers(HashStructure hash) {
        List data = hash.getAsList("indexer");
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexerInfo> infos = new ArrayList<IndexerInfo>(data.size());
        for (HashStructure h : data) {
            infos.add(new IndexerInfo(h));
        }
        return Collections.unmodifiableList(infos);
    }

    private IndexingInfo() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HashStructureHook hook = (HashStructureHook)registry.getHook(INDEXING_HOOK_NAME);
        this.listeners = MetaClassList.get((HashStructureHook)hook, (String)"listener", (String)"class", IndexingListener.class);
        if (hook != null) {
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                public void listenerAttached(HashStructureHookEvent e) {
                    this.processIndexers(e.getCombinedHashStructure());
                }

                public void elementVisited(HashStructureHookEvent e) {
                    this.processIndexers(e.getNewElementHashStructure());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void processIndexers(HashStructure hash) {
                    List newIndexers = IndexingInfo.getIndexers(hash);
                    List list = IndexingInfo.this.indexers;
                    synchronized (list) {
                        IndexingInfo.this.indexers.addAll(newIndexers);
                        for (IndexingInfoListener listener : IndexingInfo.this.indexerListeners) {
                            listener.indexersAdded(newIndexers);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexerInfo> getIndexers() {
        List<IndexerInfo> list = this.indexers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<IndexerInfo>(this.indexers));
        }
    }

    public Collection<IndexingListener> getIndexingListeners() {
        return this.listeners.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexingInfoListener(IndexingInfoListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        List<IndexerInfo> list = this.indexers;
        synchronized (list) {
            this.indexerListeners.addIfAbsent(listener);
            if (!this.indexers.isEmpty()) {
                listener.indexersAdded(this.indexers);
            }
        }
    }
}

