/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.errors.SQLExceptions;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.rt.config.setup.CdbPdbSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

class SchemaSetup {
    private static final int NO_DATA_FOUND = 1403;
    private static final int INSUFFICIENT_PRIVILEGES = 1031;
    private static final int INVALID_USERNAME_PASSWORD = 1017;
    private static final Log LOG = Log.get(SchemaSetup.class);
    private static final String GET_CDB_PDB_INFO_SQL = "declare\nl_is_cdb  VARCHAR2(10) := 'NO';\nis_root   VARCHAR2(10) := 'false';\ndb_name   VARCHAR2(30) := '';\ncon_name  VARCHAR2(30) := '';\nuser_name VARCHAR2(30) := '';\npdbname   VARCHAR2(30) := '';\nbegin\n    select cdb, name into l_is_cdb, :db_name from v$database;\n    if (l_is_cdb = 'YES') and (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then\n      :is_root := 'true';\n      begin\n        select name into :pdbname from v$containers where name = :in_pdbname ;\n      exception\n      when NO_DATA_FOUND then\n         null;\n      end;\n    end if;\n    :con_name := sys_context('USERENV','CON_NAME');\n    :user_name := sys_context('USERENV','SESSION_USER');\nend;\n";
    private static final String GET_SYSDBA_PRIV_SQL = "declare\nsysdba_priv varchar2(25);\nbegin\n  select privilege into :sysdba_priv from sys.session_privs where privilege = 'SYSDBA';end;\n";
    private static final String AS_SYSDBA = " AS SYSDBA";
    private static final String SYS = "SYS";
    private static final Setting SYS_USER = Setting.setting("DB_SYS_USER", null, "SYS");
    private static final Setting PASSWORD = Setting.setting("DB_PWD", null, null, true, new String[0]);
    private static final int MAX_INVALID_PW_ALLOWED = 2;
    private static final int MAX_INVALID_USR_ALLOWED = 4;
    private final Map<String, String> installParams;

    static void schemaParams(Console console, File war, Map<String, String> installParams) throws Exception {
        new SchemaSetup(installParams).addSchemaParams(console, war);
    }

    static void install(Map<String, String> installParams, Class<?> provider, Factory factory) throws Exception {
        if (NullOrEmpty.nullOrEmpty(installParams)) {
            return;
        }
        String installer = installParams.get("installer");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installer)) {
            if (installer.equals("install") || installer.equals("cdb.install") || installer.equals("upgrade") || installer.equals("cdb.upgrade")) {
                Class<?> type = provider;
                CommandProvider installProvider = (CommandProvider)factory.newInstance(type);
                Map requiredValues = (Map)Maps.builder().add((Object)"install.params", installParams).build();
                installProvider.execute(requiredValues);
            } else if (!installer.equals("skip")) {
                LOG.info(SetupMessages.format("SCHEMA_VERSION", installParams.get("product.name"), installParams.get("schema.version")));
            }
        }
    }

    private SchemaSetup(Map<String, String> installParams) {
        this.installParams = installParams;
    }

    private void addSchemaParams(Console console, File war) throws Exception {
        this.installParams.put("installer", null);
        String processType = this.getInstallOrUpgrade(console, war);
        LOG.fine("SchemaSetup - Processing type is " + processType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getInstallOrUpgrade(Console console, File war) throws Exception {
        block12: {
            block11: {
                block10: {
                    processType = null;
                    failedConn = false;
                    connectedAsSys = false;
                    conn = null;
                    username = this.installParams.get("user.name.public");
                    password = this.installParams.get("user.public.password");
                    url = SchemaSetup.getDbUrl(this.installParams);
                    this.installParams.put("db.url", url);
                    try {
                        errConnMsg = null;
                        useBequeath = Boolean.parseBoolean(this.installParams.get("bequeath.connect"));
                        schemaOnlyOption = Boolean.parseBoolean(this.installParams.get("schema.only"));
                        restartOnlyOption = Boolean.parseBoolean(this.installParams.get("restart.only"));
                        if (useBequeath || schemaOnlyOption || restartOnlyOption) break block10;
                        try {
                            connPassword = SchemaSetup.getPassword(password);
                            conn = DriverManager.getConnection(url, username, connPassword);
                        }
                        catch (SQLException e) {
                            errConnMsg = e.getMessage();
                            Closeables.close((Object)conn);
                            if (SQLExceptions.getErrorCode((SQLException)e) == 1017) {
                                failedConn = true;
                            }
                            msg = SetupMessages.format("ERR_CONN_FAILED", new Object[]{username, url, errConnMsg});
                            SchemaSetup.LOG.warning(msg);
                            this.installParams.put("installer", "skip");
                            var17_19 = null;
                            Closeables.close((Object)conn);
                            return var17_19;
                        }
                    }
                    catch (Throwable var18_20) {
                        Closeables.close(conn);
                        throw var18_20;
                    }
                }
                if (!failedConn && !useBequeath && !schemaOnlyOption && !restartOnlyOption) ** GOTO lbl52
                conn = SchemaSetup.verifyDBAUserConnection(console, this.installParams, url, true);
                if (conn != null && (this.installParams.get("installer") == null || !this.installParams.get("installer").equals("skip"))) break block11;
                e = null;
                Closeables.close((Object)conn);
                return e;
            }
            connectedAsSys = true;
            if (restartOnlyOption) {
                CdbPdbSetup.restartProcessingContainers(conn, this.installParams);
            } else {
                processType = CdbPdbSetup.getInstallOrUpgrade(conn, this.installParams);
            }
            break block12;
lbl52:
            // 1 sources

            processType = CdbPdbSetup.getInstallOrUpgradeForPubUser(conn, this.installParams);
        }
        if (connectedAsSys && failedConn && !NullOrEmpty.nullOrEmpty((CharSequence)processType) && (processType.equals("upgrade") || processType.equals("cdb.upgrade"))) {
            msg = SetupMessages.format("ERR_INVALID_PUB_PASSWORD", new Object[]{errConnMsg != null ? errConnMsg : ""});
            SchemaSetup.LOG.warning(msg);
        }
        Closeables.close((Object)conn);
        return processType;
    }

    private static String getPassword(String value) {
        if (value != null && value.startsWith("@")) {
            value = value.substring(1);
            value = Passwords.comingIn((String)value);
        }
        return value;
    }

    private static String getUsername(String username) {
        if (username.toUpperCase().equals(SYS) && !username.toUpperCase().endsWith(AS_SYSDBA)) {
            return username + AS_SYSDBA;
        }
        return username;
    }

    public static String getDbUrl(Map<String, String> installParams) {
        String hostName = installParams.get("db.hostname");
        String port = installParams.get("db.port");
        String sid = installParams.get("db.sid");
        String serviceName = installParams.get("db.servicename");
        String driverType = "thin";
        String url = !NullOrEmpty.nullOrEmpty((CharSequence)serviceName) ? "jdbc:oracle:thin:@//" + hostName + ":" + port + "/" + serviceName : "jdbc:oracle:thin:@" + hostName + ":" + port + ":" + sid;
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasSysDBAPrivilege(Connection conn) throws SQLException {
        OracleCallableStatement callStmt;
        block4: {
            boolean bl;
            callStmt = null;
            try {
                callStmt = (OracleCallableStatement)conn.prepareCall(GET_SYSDBA_PRIV_SQL);
                callStmt.registerOutParameter(1, 12);
                callStmt.execute();
                String sysDbaPriv = callStmt.getString(1);
                if (NullOrEmpty.nullOrEmpty((CharSequence)sysDbaPriv) || !sysDbaPriv.equals("SYSDBA")) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    LOG.fine((Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.close(callStmt);
                    throw throwable;
                }
                Closeables.close((Object)callStmt);
            }
            Closeables.close((Object)callStmt);
            return bl;
        }
        Closeables.close((Object)callStmt);
        return false;
    }

    private static void verifyBequeathConnection(Connection conn, Map<String, String> installParams) throws SQLException {
        if (CdbPdbSetup.getDBVersion(conn) >= 12) {
            Statement stmt;
            OracleCallableStatement callStmt;
            block7: {
                String serviceName = installParams.get("db.servicename");
                if (NullOrEmpty.nullOrEmpty((CharSequence)serviceName)) {
                    return;
                }
                String pdbName = serviceName.toUpperCase();
                if (pdbName.contains(".")) {
                    pdbName = pdbName.substring(0, pdbName.indexOf("."));
                }
                callStmt = null;
                stmt = null;
                boolean isRoot = false;
                try {
                    callStmt = (OracleCallableStatement)conn.prepareCall(GET_CDB_PDB_INFO_SQL);
                    callStmt.registerOutParameter(1, 12);
                    callStmt.registerOutParameter(2, 12);
                    callStmt.registerOutParameter(3, 12);
                    callStmt.setString(4, pdbName);
                    callStmt.registerOutParameter(5, 12);
                    callStmt.registerOutParameter(6, 12);
                    callStmt.execute();
                    String dbName = callStmt.getString(1);
                    isRoot = Boolean.parseBoolean(callStmt.getString(2));
                    String out_pdbName = callStmt.getString(3);
                    if (!isRoot || pdbName.equalsIgnoreCase(dbName) || NullOrEmpty.nullOrEmpty((CharSequence)out_pdbName) || !out_pdbName.toUpperCase().equals(pdbName)) break block7;
                    stmt = ((OracleConnection)conn).createStatement();
                    stmt.executeUpdate("ALTER SESSION SET CONTAINER = " + out_pdbName);
                    installParams.put("use.pdbname", out_pdbName);
                }
                catch (SQLException e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new Object[]{stmt, callStmt});
                        throw throwable;
                    }
                }
            }
            Closeables.close((Object[])new Object[]{stmt, callStmt});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection verifyDBAUserOSAuthentication(Console console, Map<String, String> installParams, boolean stayConnected) {
        Connection conn;
        block7: {
            boolean connectedAsSys = false;
            Properties props = new Properties();
            conn = null;
            try {
                props.put("internal_logon", "sysdba");
                conn = DriverManager.getConnection("jdbc:oracle:oci8:@", props);
                SchemaSetup.verifyBequeathConnection(conn, installParams);
                if (SchemaSetup.hasSysDBAPrivilege(conn)) {
                    connectedAsSys = true;
                } else {
                    installParams.put("installer", "skip");
                    String errMsg = SetupMessages.getString("ERR_INVALID_SYSDBA_USER_OS_AUTH") + "\n";
                    LOG.warning(errMsg);
                }
                if (!connectedAsSys) break block7;
                if (stayConnected) return conn;
            }
            catch (SQLException e) {
                block8: {
                    try {
                        LOG.warning(SetupMessages.format("ERR_BEQUEATH_CONN_FAILED", e.getMessage()));
                        installParams.put("installer", "skip");
                        if (!connectedAsSys) break block8;
                        if (stayConnected) return conn;
                    }
                    catch (Throwable throwable) {
                        if (connectedAsSys) {
                            if (stayConnected) throw throwable;
                        }
                        Closeables.close(conn);
                        conn = null;
                        throw throwable;
                    }
                }
                Closeables.close((Object)conn);
                return null;
            }
        }
        Closeables.close((Object)conn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection verifyDBAUserConnection(Console console, Map<String, String> installParams, String url, boolean stayConnected) {
        if (Boolean.valueOf(installParams.get("bequeath.connect")).booleanValue()) {
            return SchemaSetup.verifyDBAUserOSAuthentication(console, installParams, stayConnected);
        }
        String installType = installParams.get("install.type");
        boolean isSimpleInstall = true;
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installType) && !installType.equals("install.simple")) {
            isSimpleInstall = false;
        }
        Connection conn = null;
        try {
            String username = installParams.get("sys.user");
            String password = installParams.get("sys.password");
            if (console != null) {
                if (!isSimpleInstall || NullOrEmpty.nullOrEmpty((CharSequence)username) || NullOrEmpty.nullOrEmpty((CharSequence)password)) {
                    LOG.console(SetupMessages.getString("INFO_SYS_LOGIN") + "\n");
                    username = SYS_USER.prompt(console, new String[0]);
                    password = PASSWORD.prompt(console, username);
                }
            } else if (isSimpleInstall) {
                StringBuilder sb = null;
                if (NullOrEmpty.nullOrEmpty((CharSequence)username) && sb == null) {
                    sb = new StringBuilder("username");
                }
                if (NullOrEmpty.nullOrEmpty((CharSequence)password)) {
                    if (sb == null) {
                        sb = new StringBuilder("sys.password");
                    } else {
                        sb.append(", ").append("password");
                    }
                }
                if (sb != null) {
                    throw new Exception(SetupMessages.format("ERR_MISSING_SYS_VALUES", sb.toString()));
                }
            } else {
                throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
            }
            int totalInvalidPwd = 0;
            int totalInvalidUsr = 0;
            boolean connectedAsSys = false;
            while (!connectedAsSys && totalInvalidPwd <= 2 && totalInvalidUsr <= 4) {
                String connUsername = null;
                String errMsg = null;
                boolean validPriv = false;
                try {
                    connUsername = SchemaSetup.getUsername(username);
                    String connPassword = SchemaSetup.getPassword(password);
                    conn = DriverManager.getConnection(url, connUsername, connPassword);
                    validPriv = SchemaSetup.hasSysDBAPrivilege(conn);
                    if (validPriv) {
                        connectedAsSys = true;
                        installParams.put("sys.user", connUsername);
                        if (!password.startsWith("@")) {
                            password = "@" + Passwords.goingOut((String)password);
                        }
                        installParams.put("sys.password", password);
                        continue;
                    }
                    if (totalInvalidPwd > 0) {
                        totalInvalidPwd = 0;
                    }
                    ++totalInvalidUsr;
                    if (errMsg == null) {
                        errMsg = SetupMessages.getString("ERR_INVALID_SYSDBA_USER") + "\n";
                    }
                    console.printf("%s ", errMsg);
                    username = SYS_USER.prompt(console, new String[0]);
                    password = PASSWORD.prompt(console, username);
                }
                catch (SQLException e) {
                    boolean tryAgain = false;
                    if (console != null) {
                        if (SQLExceptions.getErrorCode((SQLException)e) == 1017 && totalInvalidPwd + 1 <= 2) {
                            errMsg = e.getMessage() + SetupMessages.getString("TRY_AGAIN");
                            console.printf("%s ", errMsg);
                            ++totalInvalidPwd;
                            tryAgain = true;
                            password = PASSWORD.prompt(console, username);
                        } else if (SQLExceptions.getErrorCode((SQLException)e) == 1031 || SQLExceptions.getErrorCode((SQLException)e) == 1403 && totalInvalidUsr + 1 <= 4) {
                            tryAgain = true;
                            errMsg = e.getMessage() + SetupMessages.getString("ERR_INVALID_SYSDBA_USER") + "\n";
                            console.printf("%s ", errMsg);
                            username = SYS_USER.prompt(console, new String[0]);
                            password = PASSWORD.prompt(console, username);
                            ++totalInvalidUsr;
                        }
                    }
                    if (tryAgain) continue;
                    errMsg = SetupMessages.format("ERR_CONN_FAILED", connUsername, url, e.getMessage());
                    LOG.warning(errMsg);
                    Closeables.close((Object)conn);
                    installParams.put("installer", "skip");
                    Connection connection = null;
                    if (!stayConnected) {
                        Closeables.close((Object)conn);
                    }
                    return connection;
                }
            }
            if (!connectedAsSys && NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer"))) {
                installParams.put("installer", "skip");
                if (totalInvalidPwd > 2) {
                    LOG.info(SetupMessages.getString("MAX_RETRY_PASSWD_ALLOWED"));
                } else if (totalInvalidUsr > 4) {
                    LOG.info(SetupMessages.getString("MAX_RETRY_USER_ALLOWED"));
                }
                LOG.warning(SetupMessages.getString("CANNOT_CONNECT_VERIFY_ORDS"));
            }
        }
        catch (Exception e) {
            installParams.put("installer", "skip");
            LOG.warning(e.getMessage());
            Closeables.close(conn);
        }
        finally {
            if (!stayConnected) {
                Closeables.close(conn);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getUninstallParams(Console console, Map<String, String> installParams, String dbURL) throws Exception {
        boolean retValue = false;
        Connection conn = SchemaSetup.verifyDBAUserConnection(console, installParams, dbURL, true);
        try {
            if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) && installParams.get("installer").equals("skip")) {
                LOG.fine("Could not get SYS username/password.");
            } else if (conn != null) {
                CdbPdbSetup.retrieveContainersToUninstall(conn, installParams);
                if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) && !installParams.get("installer").equals("skip")) {
                    retValue = true;
                }
            }
        }
        catch (Exception e) {
            LOG.warning(e.getLocalizedMessage());
        }
        finally {
            Closeables.close((Object)conn);
        }
        if (retValue) {
            installParams.put("db.url", dbURL);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getValidateParams(Console console, Map<String, String> installParams, String dbURL) throws Exception {
        boolean retValue = false;
        Connection conn = SchemaSetup.verifyDBAUserConnection(console, installParams, dbURL, true);
        try {
            if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) && installParams.get("installer").equals("skip")) {
                LOG.fine("Could not get SYS username/password.");
            } else if (conn != null) {
                CdbPdbSetup.retrieveValidateParams(conn, installParams);
                if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("installer")) && !installParams.get("installer").equals("skip")) {
                    retValue = true;
                }
            }
        }
        catch (Exception e) {
            LOG.warning(e.getLocalizedMessage());
        }
        finally {
            Closeables.close((Object)conn);
        }
        if (retValue) {
            installParams.put("db.url", dbURL);
        }
        return retValue;
    }
}

