/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.rt.uri.ValidURITemplate;
import oracle.dbtools.rt.validation.ConstraintValidator;

public class URITemplateValidator
implements ConstraintValidator<ValidURITemplate, String> {
    private static final Pattern START_PARAM = Pattern.compile("\\{");
    private static final Pattern VALID_PARAM = Pattern.compile("^\\{\\p{Alpha}[\\p{Alnum}|_|-]*?\\}");

    @Override
    public void initialize(ValidURITemplate constraintAnnotation) {
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        Matcher m = START_PARAM.matcher(value);
        while (m.find()) {
            int start = m.start();
            CharSequence restOfValue = value.subSequence(start, value.length());
            Matcher p = VALID_PARAM.matcher(restOfValue);
            if (p.find()) continue;
            return false;
        }
        return true;
    }
}

