/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.fileupload;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.web.HttpHeader;
import org.apache.commons.fileupload.RequestContext;

class EntityRequestContext
implements RequestContext {
    private final Entity entity;

    EntityRequestContext(Entity entity) {
        this.entity = entity;
    }

    public String getCharacterEncoding() {
        String charset = null;
        EntityHeader h = this.entity.headers().header("X-APEX-CHARSET");
        if (h != null) {
            charset = h.value();
        }
        return charset;
    }

    public int getContentLength() {
        int length = -1;
        EntityHeader h = this.entity.headers().header(HttpHeader.CONTENT_LENGTH);
        if (h != null) {
            length = Integer.parseInt(h.value());
        }
        return length;
    }

    public String getContentType() {
        String ct = null;
        EntityHeader h = this.entity.headers().header(HttpHeader.CONTENT_TYPE);
        if (h != null) {
            ct = h.value();
        }
        return ct;
    }

    public InputStream getInputStream() throws IOException {
        return this.entity.body();
    }
}

