/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.actions.RenameAWDialog;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;

public class RenameAWAction
extends AbstractMenuAction {
    public void launch() {
        String string = String.valueOf(this.getDBObject().getNode().getData());
        final RenameAWDialog renameAWDialog = new RenameAWDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("RENAME_AW_DIALOG_TITLE"), "", string, this.getDBObject().getSchemaName(), this.getDBObject().getDatabase());
        renameAWDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        renameAWDialog.setVisible(true);
        if (renameAWDialog.isOkClicked()) {
            String string2 = OLAPArb.getString("RENAME_AW_PROGRESS_TITLE");
            RaptorTask raptorTask = new RaptorTask(string2, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        RenameAWAction.this.commitRename(renameAWDialog.getNewAWName());
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(string2);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRename(String string) {
        Connection connection = this.getDBObject().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string2 = String.valueOf(this.getDBObject().getNode().getData());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("oldName", string2);
        hashMap.put("newName", string);
        String string3 = "call dbms_aw.aw_rename(:oldName,:newName)";
        Statement statement = null;
        try {
            Connections.getInstance().lock(connection);
            statement = dBUtil.prepareExecute(string3, hashMap);
            statement.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                statement.close();
                Connections.getInstance().unlock(connection);
                OLAPMetadataCache.getUpdatedSchema(this.getDBObject().getConnectionName(), this.getDBObject().getSchemaName());
            }
            catch (Exception exception) {}
        }
    }
}

