/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.ChildObjectEditorPanel2;

public class CubeMeasureEditorPanel
extends ChildObjectEditorPanel2<CubeMeasure, Cube> {
    private JLabel lblName = new JLabel();
    private DBObjectProvider prov;
    private DataTypeUI dataTypeUI;
    private TreeSet<CubeMeasure> invalidMeasures = new TreeSet(new DBObjectComparator());
    private JCheckBox defaultMeasureCheckbox;

    public CubeMeasureEditorPanel() {
        super("CubeMeasureEditorPanel", "MEASURE");
        this.lblName.setName("lblName");
        this.layoutComponents();
    }

    private void updateMeasureData() {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.defaultMeasureCheckbox.setSelected(false);
            this.lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
            this.enableDescriptions(false);
            this.dataTypeUI.setEnabled(false);
        } else {
            String string = ((CubeMeasure)this.getChildObject()).getName();
            if (!this.invalidMeasures.contains(this.getChildObject())) {
                // empty if block
            }
            CubeMeasure cubeMeasure = (CubeMeasure)this.getChildObject();
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            this.enableDescriptions(true);
            childNameObjectEditorContext.setEditingState(0);
            if (cubeMeasure.getCube().getMeasures().length > 1) {
                this.defaultMeasureCheckbox.setSelected(((CubeMeasure)this.getChildObject()).isDefault());
            } else {
                this.defaultMeasureCheckbox.setSelected(true);
            }
            String string2 = ((CubeMeasure)this.getChildObject()).getDataType();
            this.dataTypeUI.setSQLDataType(string2);
            this.dataTypeUI.setEnabled(true);
        }
        this.validate();
        this.repaint();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.setMeasure((CubeMeasure)this.getChildObject());
    }

    public void commit(CubeMeasure cubeMeasure) throws TraversalException {
        CubeMeasure cubeMeasure2 = (CubeMeasure)cubeMeasure.copyTo(null);
        try {
            this.prov.validateName("MEASURE", this.getNameField().getText());
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidMeasures.add(cubeMeasure);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidMeasures.contains(cubeMeasure)) {
            this.invalidMeasures.remove(cubeMeasure);
        }
        String string = this.prov.getInternalName(this.getNameField().getText());
        cubeMeasure2.setName(string);
        String string2 = this.dataTypeUI.getSQLDataType();
        cubeMeasure2.setDataType(string2);
        cubeMeasure2.setShortDescription(this.getShortDescriptionFld().getText());
        cubeMeasure2.setLongDescription(this.getLongDescriptionFld().getText());
        cubeMeasure2.setDescription(this.getDescriptionFld().getText());
        cubeMeasure2.setDefault(this.defaultMeasureCheckbox.isSelected());
        cubeMeasure2.copyTo(cubeMeasure);
    }

    public void setMeasure(CubeMeasure cubeMeasure) {
        this.updateMeasureData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeMeasure cubeMeasure = (CubeMeasure)this.getChildObject();
        String string = cubeMeasure.getName();
        this.commit(cubeMeasure);
        Cube cube = cubeMeasure.getCube();
        if (cube.findMeasure(cubeMeasure.getName()) == null) {
            cube.addMeasure(cubeMeasure);
        } else if (!cubeMeasure.getName().equals(string)) {
            cubeMeasure.getCube().propagateRenameToExpressions(string, cubeMeasure.getName(), true);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"measures"});
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "Name", "name");
        this.registerDescriptionFields();
        this.getNameField().setColumns(30);
        this.dataTypeUI = new DataTypeUI(componentFactory);
        this.dataTypeUI.removeDataTypel("DATETIME");
        this.dataTypeUI.getDataTypeComboBox().setSelectedItem("VARCHAR2");
        this.defaultMeasureCheckbox = new JCheckBox(OLAPArb.getString("CUBE_SET_DEFAULT_MEASURE"));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_MEASURE_PROPERTIES")));
        this.add(this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getNameField(), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        int n = this.layoutDescriptionFields(1);
        this.add(this.dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.defaultMeasureCheckbox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.defaultMeasureCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeMeasure cubeMeasure = (CubeMeasure)CubeMeasureEditorPanel.this.getChildObject();
                Cube cube = cubeMeasure.getCube();
                for (CubeMeasure cubeMeasure2 : cube.getMeasures()) {
                    cubeMeasure2.setDefault(false);
                }
                cubeMeasure.setDefault(CubeMeasureEditorPanel.this.defaultMeasureCheckbox.isSelected());
            }
        });
    }
}

