/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.CubeCatalogDialog;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplateSelector;

class DetailsPanel
extends JPanel {
    private final JTextField uiTemplateName;
    private final JTextField uiDescription;
    private final JTextField uiComments;
    private final TemplateSelector selector;
    private final Resources resources;

    public DetailsPanel(CubeCatalogDialog.Mode mode, TemplateSelector templateSelector, String string, String string2, ObjectType objectType, Resources resources) {
        super(new GridBagLayout());
        this.resources = resources;
        this.selector = templateSelector;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = null;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        gridBagConstraints.anchor = 21;
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.FORM.TEMPLATE_NAME");
        jLabel.setName("lb");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.uiTemplateName = new JTextField(20);
        this.uiTemplateName.setName("uiTemplateName");
        jLabel.setLabelFor(this.uiTemplateName);
        this.uiTemplateName.setMinimumSize(this.uiTemplateName.getPreferredSize());
        this.add((Component)this.uiTemplateName, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.FORM.DESCRIPTION");
        jLabel.setName("lb");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        this.uiDescription = new JTextField(20);
        this.uiDescription.setName("uiDescription");
        jLabel.setLabelFor(this.uiDescription);
        this.uiDescription.setMinimumSize(this.uiDescription.getPreferredSize());
        this.add((Component)this.uiDescription, gridBagConstraints);
        if (mode == CubeCatalogDialog.Mode.EXPORT) {
            this.uiTemplateName.setText(string);
            this.uiDescription.setText(string2);
        }
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.FORM.COMMENTS");
        jLabel.setName("lb");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        this.uiComments = new JTextField(40);
        this.uiComments.setName("uiComments");
        jLabel.setLabelFor(this.uiComments);
        this.uiComments.setMinimumSize(this.uiComments.getPreferredSize());
        this.add((Component)this.uiComments, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = this.newJLabel("EXPORT_TO_TABLE.DIALOG.FORM.OBJECT_TYPE");
        jLabel.setName("lb");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        JComboBox<ObjectType> jComboBox = new JComboBox<ObjectType>(ObjectType.values());
        jComboBox.setName("uiTemplateType");
        jLabel.setLabelFor(jComboBox);
        jComboBox.setMinimumSize(new Dimension(500, (int)jComboBox.getMinimumSize().getHeight()));
        jComboBox.setSelectedItem((Object)objectType);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DetailsPanel.this.selector.setObjectType((ObjectType)((Object)itemEvent.getItem()));
                    DetailsPanel.this.selector.refresh();
                }
            }
        });
        this.add(jComboBox, gridBagConstraints);
    }

    public JLabel newJLabel(String string) {
        String string2 = this.resources.getString(string);
        int n = string2.indexOf("&");
        JLabel jLabel = new JLabel(string2.replaceFirst("&", ""));
        jLabel.setName("label");
        if (n != -1) {
            jLabel.setDisplayedMnemonicIndex(n);
            jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n));
        }
        return jLabel;
    }

    public String getTemplateName() {
        return this.uiTemplateName.getText();
    }

    public void setTemplateName(String string) {
        this.uiTemplateName.setText(string);
    }

    public String getDescription() {
        return this.uiDescription.getText();
    }

    public void setDescription(String string) {
        this.uiDescription.setText(string);
    }

    public String getComments() {
        return this.uiComments.getText();
    }

    public void setComments(String string) {
        this.uiComments.setText(string);
    }

    public boolean isSelectionValid() {
        return this.uiTemplateName.getText().length() > 0;
    }
}

