/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.olap.OLAPArb;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.db.model.LanguageDescriptionsHelper;

public class AbstractSchemaObjectValidator<T extends AbstractSchemaObjectWithDesc>
extends SchemaObjectValidator<T> {
    private static final String VALID_CHARS = "^\\p{L}[\\p{Alnum}_A-Z[a-z]\u00aa\u00b5\u00ba[\u00c0-\u00d6][\u00d8-\u00f6][\u00f8-\u02b8][\u02bb-\u02c1]\u02c7[\u02c9-\u02cb]\u02ce\u02d1\u02d9[\u02e0-\u02e4]\u02ee[\u0300-\u0373][\u0376-\u037d][\u037f-\u0383]\u0386[\u0388-\u03f5][\u03f7-\u0481][\u0483-\u0559][\u0560-\u0588][\u058b-\u05af]\u05ba\u05c5 [\u05c7-\u05f2][\u05f5-\u05ff][\u0604-\u060a][\u0610-\u061a][\u061c-\u061d][\u0620-\u063f][\u0641-\u065f][\u066e-\u06d3][\u06d5-\u06dc][\u06de-\u06e8][\u06ea-\u06ef][\u06fa-\u06fc]\u06ff  \u070e[\u0710-\u07bf][\u07ca-\u07f5][\u07fa-\u0900][\u0904-\u093b][\u094e-\u0963][\u0971-\u09e5][\u09f0-\u09f1][\u09fb-\u0a65][\u0a70-\u0ae5]\u0af0[\u0af2-\u0b65][\u0b71-\u0be5][\u0bfb-\u0c65][\u0c70-\u0ce5]\u0cf0[\u0cf3-\u0d65][\u0d70-\u0df3][\u0df5-\u0e2e][\u0e30-\u0e3e][\u0e40-\u0e45][\u0e47-\u0e4d][\u0e5c-\u0ecf][\u0eda-\u0f00][\u0f18-\u0f19]\u0f35\u0f37\u0f39[\u0f3e-\u0f84][\u0f86-\u0fbd]\u0fc6[\u0fcd-\u0fce][\u0fd2-\u103f][\u1050-\u10fa][\u10fc-\u135f][\u137d-\u138f][\u139a-\u166c][\u166f-\u167f][\u1681-\u169a][\u169d-\u16ea][\u16f1-\u1734][\u1737-\u17d3]\u17d7[\u17dc-\u17df][\u17ea-\u17ef][\u17fa-\u17ff][\u180b-\u180d]\u180f[\u181a-\u193f][\u1941-\u1943][\u1950-\u19cf][\u19da-\u19dd][\u1a00-\u1a1d][\u1a20-\u1b4f][\u1b6b-\u1b73][\u1b7d-\u1fbc]\u1fbe[\u1fc2-\u1fcc][\u1fd0-\u1fdc][\u1fe0-\u1fec][\u1ff0-\u1ffc]\u1fff\u2015[\u2064-\u2069][\u2071-\u2073][\u208f-\u209f][\u20b6-\u20ff]\u2102\u2107[\u210a-\u2113]\u2115[\u2119-\u211d]\u2124\u2128\u212a[\u212c-\u212d][\u212f-\u2139][\u213c-\u213f][\u2145-\u2149][\u214e-\u2152][\u2180-\u218f][\u23e8-\u2421][\u2427-\u243f][\u244b-\u2487][\u269d-\u269f][\u26b3-\u2700]\u2705[\u270a-\u270b]\u2728\u274c\u274e[\u2753-\u2755]\u2757[\u275f-\u2760][\u2795-\u2797]\u27b0\u27bf[\u27cb-\u27cf][\u27ec-\u27ef][\u2b1b-\u2b1f][\u2b24-\u2ce4][\u2ceb-\u2cf8][\u2d00-\u2dff][\u2e18-\u2e1b][\u2e1e-\u2fef][\u2ffc-\u2fff]\u3003[\u3005-\u3006]\u301c[\u3021-\u302f][\u3031-\u3035][\u3038-\u303c][\u3040-\u309a][\u309d-\u309f][\u30a1-\u30fa][\u30fc-\u318f][\u3192-\u31bf][\u31d0-\u31ff]\u321f[\u3244-\u324f]\u32ff[\u3400-\u4dbf][\u4e00-\ua48f][\ua4c7-\ua6ff][\ua717-\ua71f][\ua722-\ua827][\ua82c-\ua873][\ua878-\ud7ff][\udb9e-\udbb5][\udbb7-\udbff][\ue000-\ufb1e][\ufb20-\ufb28][\ufb2a-\ufd3d][\ufd40-\ufdfb][\ufdfe-\ufe0f][\ufe1a-\ufe2f]\ufe53\ufe67[\ufe6c-\ufefe]\uff00[\uff21-\uff3a]\uff3f[\uff41-\uff5a][\uff66-\uffdf]\uffe7[\uffef-\ufff8][\ufffd-\uffff]]*$";

    public AbstractSchemaObjectValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        if (!string2.matches(VALID_CHARS)) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME"));
        }
        if (string2.length() > 30) {
            throw new InvalidNameException(null, OLAPArb.getString("VALIDATOR_ERROR_MSG_INVALID_NAME_LENGTH"));
        }
    }

    public void validateLanguageDescriptionsForObject(Map<String, Boolean> map, LanguageDescriptionsHelper languageDescriptionsHelper) {
        for (LanguageDescription languageDescription : languageDescriptionsHelper.getLanguageDescriptions()) {
            if (!map.containsKey(languageDescription.getLanguage())) {
                map.put(languageDescription.getLanguage(), false);
            }
            map.put(languageDescription.getLanguage(), map.get(languageDescription.getLanguage()) != false || !this.emptyLanguageDescription(languageDescription));
        }
    }

    public boolean areLanguageDescriptionsValid(Map<String, Boolean> map) {
        boolean bl = true;
        for (String string : map.keySet()) {
            bl = bl && map.get(string) != false;
        }
        return bl;
    }

    private boolean emptyLanguageDescription(LanguageDescription languageDescription) {
        return !(languageDescription.getDescription() != null && !languageDescription.getDescription().isEmpty() || languageDescription.getShortDescription() != null && !languageDescription.getShortDescription().isEmpty() || languageDescription.getLongDescription() != null && !languageDescription.getLongDescription().isEmpty());
    }
}

