/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.navigator.calculatedmeasure;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.controller.IdeAction;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.ojc.interfaces.Storage;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.syntaxparser.ParseException;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.db.CubeCalcPersistSQL;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.OLAPExceptionHandler;
import oracle.olap.ddl.CubeDDLSupport;
import oracle.olap.navigator.OLAPNavigatorResource;
import oracle.olap.navigator.calculatedmeasure.DockableSpecTree;
import oracle.olap.syntaxbuilder.editor.CalculatedMeasureCompilerPage;
import oracle.olap.syntaxbuilder.editor.EditorActions;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;

public class CalculatedMeasureNode
extends DatabaseSourceNode
implements Comparable {
    private static Logger LOG = Logger.getLogger(CalculatedMeasureNode.class.getName());
    public static final String TYPE_CALC_MEASURE_EXPRESSION = "CALCMEASURE";
    public static final String MEASURE_NAME_KEY = "MEASURE_NAME";
    public static final String CUBE_NAME_KEY = "CUBE_NAME";
    public static final String COMPILE_ERROR_LINE_NUMBER_KEY = "COMPILE_ERROR_LINE_NUMBER";
    public static final String COMPILE_ERROR_COLUMN_NUMBER_KEY = "COMPILE_ERROR_COLUMN_NUMBER";
    private Boolean isBreadcrumbsOn;
    private Boolean isGutterNavOn;
    private String connectionName;
    private String measure;
    private String cube;
    private String schema;
    private String fullName;
    private TemplateHandler templateHandler;
    private ObjectFolder folderNode;
    private String description;
    private String longLabel;
    private String shortLabel;
    private boolean isCompiled = false;
    private boolean isCompiledWithErrors = false;
    private List<Throwable> lastCompileErrorsList = null;
    private Throwable sqlError;
    private static final Pattern errorPattern = Pattern.compile("^Lexical error at line (\\d+), column (\\d+)\\..*");
    private static final Pattern newLinePattern = Pattern.compile("\r?\n");

    public void openImpl() throws IOException {
        if (this.isBreadcrumbsOn()) {
            PlSqlFeatures.setSupportedBreadcrumbs((boolean)false);
        }
        if (this.isGutterNavOn()) {
            PlSqlFeatures.setSupportedGutterNavigation((boolean)false);
        }
        super.openImpl();
    }

    public boolean isBreadcrumbsOn() {
        if (this.isBreadcrumbsOn == null) {
            this.isBreadcrumbsOn = PlSqlFeatures.isSupportedBreadcrumbs();
        }
        return this.isBreadcrumbsOn;
    }

    public boolean isGutterNavOn() {
        if (this.isGutterNavOn == null) {
            this.isGutterNavOn = PlSqlFeatures.isSupportedGutterNavigation();
        }
        return this.isGutterNavOn;
    }

    public String getCubeName() {
        return (String)this.getProperty(CUBE_NAME_KEY);
    }

    public String getMeasureName() {
        return (String)this.getProperty(MEASURE_NAME_KEY);
    }

    public Icon getIcon() {
        return OLAPNavigatorResource.getIcon("OLAPCALCMEASURE_ICON");
    }

    protected Reader createReader(URL uRL) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        this.setURL(uRL);
        hashMap.put("MEASURE", this.measure);
        hashMap.put("CUBE", this.cube);
        hashMap.put("SCHEMA", this.schema);
        try {
            Connection connection = Connections.getInstance().getConnection(this.getConnectionName());
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string = dBUtil.executeOracleReturnOneCol("select EXPRESSION from ALL_CUBE_MEASURES where OWNER = :SCHEMA and CUBE_NAME =:CUBE and MEASURE_NAME = :MEASURE", hashMap);
            DBObjectProvider dBObjectProvider = this.getProvider();
            String string2 = CubeDDLSupport.getDatabaseCompatibleLevel(dBObjectProvider);
            if (string != null) {
                Properties properties = new Properties();
                OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(null, properties);
                String string3 = null;
                if (!string2.startsWith("12.2")) {
                    SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null);
                    string = syntaxObject.toSyntax(this.schema);
                    string3 = oLAPISyntaxParser.formatSyntax(string);
                } else {
                    SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null);
                    string = syntaxObject.toSyntax(this.schema);
                    string3 = oLAPISyntaxParser.formatSyntax(string);
                }
                if (oLAPISyntaxParser.parseSyntax(string3, null)) {
                    this.callDefaultTemplate();
                    return new StringReader(string3);
                }
                this.callDefaultTemplate();
                return new StringReader(string);
            }
            LOG.severe(String.format("Could not fetch measure expression for measure,cube,shema = %s,%s,%s", this.measure, this.cube, this.schema));
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return new StringReader("");
    }

    private void callDefaultTemplate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalculatedMeasureNode.this.templateHandler.callDefaultTemplate();
            }
        });
    }

    public Object getProperty(String string) {
        String string2 = null;
        if ("TYPE".equals(string)) {
            string2 = TYPE_CALC_MEASURE_EXPRESSION;
        } else if ("NAME".equals(string)) {
            string2 = this.fullName;
        } else if ("SCHEMA".equals(string)) {
            string2 = this.schema;
        } else if (MEASURE_NAME_KEY.equals(string)) {
            string2 = this.measure;
        } else if (CUBE_NAME_KEY.equals(string)) {
            string2 = this.cube;
        } else if ("ConnectionName".equals(string)) {
            string2 = this.connectionName;
        } else {
            if ("RUNNABLE".equals(string)) {
                return Boolean.TRUE.toString();
            }
            string2 = this.getNodeInstance() == null ? null : this.getNodeInstance().getProperty(string);
        }
        return string2;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        if (uRL != null) {
            this.fullName = DBURLFormatHelper.getName((URL)uRL);
            IdentifierElement identifierElement = new IdentifierElement(this.fullName);
            this.connectionName = DBURLFormatHelper.getConnectionName((URL)uRL);
            this.cube = identifierElement.getFirst();
            this.measure = identifierElement.getSecond();
            this.schema = DBURLFormatHelper.getSchema((URL)uRL);
        }
    }

    public String getConnectionName() {
        return (String)this.getProperty("ConnectionName");
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            return;
        }
        if (!"TYPE".equals(string)) {
            if ("NAME".equals(string)) {
                this.fullName = object.toString();
            } else if ("SCHEMA".equals(string)) {
                this.schema = object.toString();
            } else if ("ConnectionName".equals(string)) {
                this.connectionName = object.toString();
            } else if (this.getNodeInstance() != null) {
                this.getNodeInstance().setProperty(string, object);
            }
        }
    }

    public String getObjectType() {
        return TYPE_CALC_MEASURE_EXPRESSION;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public Object getProviderIdentifier() {
        return this.connectionName;
    }

    public String getObjectName() {
        return this.fullName;
    }

    public int compareTo(Object object) {
        String string;
        if (object instanceof CalculatedMeasureNode && this.getMeasureName() != null && (string = ((CalculatedMeasureNode)object).getMeasureName()) != null) {
            return this.getMeasureName().compareTo(string);
        }
        return 0;
    }

    protected void saveImpl() throws IOException {
        this.commit(this.getConnectionName(), this.getSchemaName(), this.getCubeName(), this.getMeasureName(), this.description, this.shortLabel, this.longLabel, this.getSource());
        IdeAction ideAction = IdeAction.find((int)EditorActions.Type.COMPILE.getCommandId());
        if (ideAction != null) {
            try {
                ideAction.performAction(Context.newIdeContext((Node)this));
            }
            catch (Exception exception) {
                LOG.warning(String.format("Error compiling %s after save.", this.getMeasureName()));
            }
        }
        if (this.folderNode != null) {
            this.folderNode = null;
        }
        try {
            oracle.olap.app.olapmetadata.Schema schema = OLAPMetadataCache.getUpdatedSchema(this.getConnectionName(), this.getSchemaName());
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
        }
    }

    protected void closeImpl() throws IOException {
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.getLogPageView().close();
        super.closeImpl();
    }

    private void commit(String string, String string2, String string3, final String string4, String string5, String string6, String string7, String string8) {
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            DatabaseImpl databaseImpl = new DatabaseImpl(connection);
            oracle.olap.app.olapmetadata.Schema schema = OLAPMetadataCache.getSchema(string, string2);
            Properties properties = new Properties();
            properties.setProperty("SCHEMA", string2);
            if (schema == null) {
                schema = SyntaxBuilderLauncher.populateSchema(null, properties, null, databaseImpl);
            }
            Cube cube = (Cube)schema.getNamedObject(string3);
            if (string8 == null) {
                string8 = "0";
            }
            oracle.olap.cube.model.Cube cube2 = CalculatedMeasureNode.getCube(string2, cube.getAWName(), string3);
            CubeCalcPersistSQL cubeCalcPersistSQL = null;
            String string9 = "FREE_FORM";
            try {
                SpecTreeNode specTreeNode;
                ParseNode parseNode;
                OLAPISyntaxParser oLAPISyntaxParser;
                string8 = string8.replace("'", "''");
                Spec spec = DockableSpecTree.getInstance().getSpec(string, string2, string3);
                if (spec != null && (oLAPISyntaxParser = new OLAPISyntaxParser(schema, new Properties())).parseSyntax(string8, parseNode = new ParseNode()) && parseNode.getChildCount() == 1 && (specTreeNode = spec.findMatchingNode(parseNode.getChildren().get(0))) != null && !"QDRMEASURE".equals(specTreeNode.getType())) {
                    string9 = specTreeNode.getType();
                }
                cubeCalcPersistSQL = new CubeCalcPersistSQL(databaseImpl, cube, cube2);
                if (string5 != null && string5.trim().isEmpty()) {
                    string5 = null;
                }
                if (string6 != null && string6.trim().isEmpty()) {
                    string6 = null;
                }
                if (string7 != null && string7.trim().isEmpty()) {
                    string7 = null;
                }
                cubeCalcPersistSQL.addUpdateMeasure(string4, string8, string9, string5, string6, string7);
                cubeCalcPersistSQL.commit();
                this.sqlError = null;
                this.isCompiled = true;
                this.isCompiledWithErrors = false;
            }
            catch (Exception exception) {
                this.isCompiledWithErrors = true;
                this.sqlError = exception;
                this.setLastCompileErrorsList(this.lastCompileErrorsList);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OLAPExceptionHandler.handleException(null, OLAPArb.format("EXPRESSION_EDITOR_SAVE_CALC_MEASURE_ERROR", string4));
                        CalculatedMeasureNode.this.logError(CalculatedMeasureNode.this.lastCompileErrorsList);
                    }
                });
            }
        }
        catch (DBException dBException) {
            LOG.log(Level.SEVERE, dBException.getLocalizedMessage(), dBException);
        }
    }

    private static oracle.olap.cube.model.Cube getCube(String string, String string2, String string3) {
        oracle.olap.cube.model.Cube cube = new oracle.olap.cube.model.Cube();
        cube.setName(string3);
        cube.setSchema(new Schema(string));
        cube.setAnalyticWorkspace(string2);
        return cube;
    }

    public void setTemplateHandler(TemplateHandler templateHandler) {
        this.templateHandler = templateHandler;
    }

    public TemplateHandler getTemplateHandler() {
        return this.templateHandler;
    }

    public void setFolderNode(ObjectFolder objectFolder) {
        this.folderNode = objectFolder;
    }

    public void setDescriptions(String string, String string2, String string3) {
        this.description = string;
        this.longLabel = string2;
        this.shortLabel = string3;
    }

    public void logMessage(String string) {
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("CalculatedMeasureCompilerPage.URL", (Object)this.getURL());
        IdeLog ideLog = new IdeLog();
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)this.getConnectionName()));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        if (this.isCompiled) {
            Diagnostic diagnostic = new Diagnostic(Diagnostic.Kind.INFO);
            diagnostic.setStorage((Storage)ideStorage);
            diagnostic.setLine(1);
            diagnostic.setColumn(1);
            diagnostic.setNumber(0);
            diagnostic.setMessage(string);
            ideLog.diagnostic(diagnostic);
        }
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
    }

    public void logError(List<Throwable> list) {
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("CalculatedMeasureCompilerPage.URL", (Object)this.getURL());
        IdeLog ideLog = new IdeLog();
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)this.getConnectionName()));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        if (list == null) {
            return;
        }
        if (this.isCompiledWithErrors) {
            for (Throwable throwable : list) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                Map<String, Integer> map = this.getCompileErrorLocation(throwable);
                n = map.get(COMPILE_ERROR_LINE_NUMBER_KEY);
                n2 = map.get(COMPILE_ERROR_COLUMN_NUMBER_KEY);
                ideLog.error((Storage)ideStorage, n, n2, n3, throwable.getLocalizedMessage());
            }
        }
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
    }

    public Map<String, Integer> getCompileErrorLocation(Throwable throwable) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 1;
        int n2 = 1;
        try {
            Matcher matcher;
            Object object;
            if (throwable instanceof SyntaxException) {
                object = (SyntaxException)throwable;
                if (object.getParameters().length == 4) {
                    n = Integer.parseInt(object.getParameters()[1]);
                    n2 = Integer.parseInt(object.getParameters()[2]);
                }
            } else if (throwable instanceof ParseException) {
                object = (ParseException)throwable;
                int n3 = 1;
                String string = this.getSource();
                Matcher matcher2 = newLinePattern.matcher(string);
                while (matcher2.find() && matcher2.start() <= ((ParseException)object).getOffset()) {
                    ++n3;
                }
                n = n3 == 0 ? 1 : n3;
                n2 = string.lastIndexOf("\n", ((ParseException)object).getOffset());
                n2 = ((ParseException)object).getOffset() - n2;
            }
            object = throwable.getMessage();
            if (n == 0 && object != null && (matcher = errorPattern.matcher((CharSequence)object)).matches() && matcher.groupCount() == 3) {
                n = Integer.parseInt(matcher.group(1));
                n2 = Integer.parseInt(matcher.group(2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
            n2 = 1;
        }
        hashMap.put(COMPILE_ERROR_LINE_NUMBER_KEY, n);
        hashMap.put(COMPILE_ERROR_COLUMN_NUMBER_KEY, n2);
        return hashMap;
    }

    public void clearCompileLog() {
        LogPage logPage = CalculatedMeasureCompilerPage.getErrorLog();
        logPage.clearAll();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setCompiled(boolean bl) {
        this.isCompiled = bl;
    }

    public boolean isCompiledWithErrors() {
        return this.isCompiledWithErrors;
    }

    public void setCompiledWithErrors(boolean bl) {
        this.isCompiledWithErrors = bl;
    }

    public List<Throwable> getLastCompileErrorsList() {
        return this.lastCompileErrorsList;
    }

    public void setLastCompileErrorsList(List<Throwable> list) {
        this.lastCompileErrorsList = list;
        if (this.sqlError != null) {
            if (this.lastCompileErrorsList == null) {
                this.lastCompileErrorsList = new ArrayList<Throwable>();
            } else {
                for (Throwable throwable : this.lastCompileErrorsList) {
                    if (!(throwable instanceof SQLException)) continue;
                    this.lastCompileErrorsList.remove(throwable);
                    break;
                }
            }
            this.lastCompileErrorsList.add(this.sqlError);
        }
    }
}

