/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.preferences;

import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.olap.OLAPArb;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class OLAPBuildLogPreferencesPanel
extends DefaultTraversablePanel {
    private JComboBox logLevelComboBox;
    private JLabel logLevelLabel;
    private JLabel maxErrorsLoggedLabel;
    private JTextField maxErrorsLoggedTextField;
    private JLabel refreshTimerLabel;
    private JComboBox refreshTimerComboBox;

    public OLAPBuildLogPreferencesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setHelpID("olap_preferences_build_log");
        this.maxErrorsLoggedLabel = new JLabel();
        this.maxErrorsLoggedLabel.setText(StringUtils.stripMnemonic((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_MAX_ERRORS")));
        this.maxErrorsLoggedLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_MAX_ERRORS")));
        this.maxErrorsLoggedLabel.setName("maxErrorsLoggedLabel");
        this.maxErrorsLoggedTextField = new NumberTextField();
        this.maxErrorsLoggedTextField.setName("maxErrorsLoggedTextField");
        this.logLevelComboBox = new JComboBox();
        this.logLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_ACTION"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_NOTICE"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_INFO"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_STATS"), OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_DEBUG")}));
        this.logLevelComboBox.setName("logLevelComboBox");
        this.logLevelLabel = new JLabel();
        this.logLevelLabel.setLabelFor(this.logLevelComboBox);
        this.logLevelLabel.setText(StringUtils.stripMnemonic((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL")));
        this.logLevelLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL")));
        this.logLevelLabel.setName("logLevelLabel");
        this.refreshTimerLabel = new JLabel(OLAPArb.getString("OLAP_PREFERENCES_BUILD_LOG_REFRESH_TIMER_LABEL"));
        this.refreshTimerLabel.setName("refreshTimerLabel");
        this.refreshTimerComboBox = new JComboBox();
        this.refreshTimerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "5", "10", "15", "20", "25", "30", "60", "120"}));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup().addContainerGap();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false);
        parallelGroup.addComponent(this.logLevelLabel, -1, -1, Short.MAX_VALUE).addGap(20).addComponent(this.maxErrorsLoggedLabel, -1, -1, Short.MAX_VALUE).addGap(20).addComponent(this.refreshTimerLabel, -1, -1, Short.MAX_VALUE).addGap(20);
        sequentialGroup.addGroup(parallelGroup.addGap(5, 5, 5));
        parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false);
        parallelGroup.addComponent(this.logLevelComboBox, 0, 135, Short.MAX_VALUE).addGap(20).addComponent(this.maxErrorsLoggedTextField, 0, -1, Short.MAX_VALUE).addGap(20).addComponent(this.refreshTimerComboBox, 0, -1, Short.MAX_VALUE).addGap(20);
        sequentialGroup.addGroup(parallelGroup);
        groupLayout.setHorizontalGroup(sequentialGroup);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup().addContainerGap();
        parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        parallelGroup.addComponent(this.logLevelLabel).addComponent(this.logLevelComboBox, -2, -1, -2);
        sequentialGroup2.addGroup(parallelGroup.addGap(25));
        parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        parallelGroup.addComponent(this.maxErrorsLoggedLabel).addComponent(this.maxErrorsLoggedTextField, -2, -1, -2);
        sequentialGroup2.addGroup(parallelGroup.addGap(25));
        parallelGroup = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        parallelGroup.addComponent(this.refreshTimerLabel).addComponent(this.refreshTimerComboBox, -2, -1, -2);
        sequentialGroup2.addGroup(parallelGroup);
        groupLayout.setVerticalGroup(sequentialGroup2);
    }

    public void onEntry(TraversableContext traversableContext) {
        OLAPBuildLogPreferenceSettings oLAPBuildLogPreferenceSettings = this.getOLAPFeaturePrefs(traversableContext);
        String string = oLAPBuildLogPreferenceSettings.getLogLevelName();
        int n = oLAPBuildLogPreferenceSettings.getMaxErrorsLogged();
        this.logLevelComboBox.setSelectedItem(string);
        NumberTextField numberTextField = (NumberTextField)this.maxErrorsLoggedTextField;
        numberTextField.setNumber((Number)n);
        this.refreshTimerComboBox.setSelectedItem(String.valueOf(oLAPBuildLogPreferenceSettings.getQueriesRefreshTime()));
    }

    public void onExit(TraversableContext traversableContext) {
        OLAPBuildLogPreferenceSettings oLAPBuildLogPreferenceSettings = this.getOLAPFeaturePrefs(traversableContext);
        String string = (String)this.logLevelComboBox.getSelectedItem();
        oLAPBuildLogPreferenceSettings.setLogLevel(string);
        NumberTextField numberTextField = (NumberTextField)this.maxErrorsLoggedTextField;
        oLAPBuildLogPreferenceSettings.setMaxErrorsLogged(numberTextField.getNumber().intValue());
        oLAPBuildLogPreferenceSettings.setQueriesRefreshTime((String)this.refreshTimerComboBox.getSelectedItem());
    }

    private OLAPBuildLogPreferenceSettings getOLAPFeaturePrefs(TraversableContext traversableContext) {
        return OLAPBuildLogPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

