/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.sql;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.metadata.JdbcMetadataProvider;
import com.adbs.querybuilder.AddObjectDialogOptions;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.ObjectsGroupingType;
import com.adbs.querybuilder.ObjectsSortingType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStatistics;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.querybuilder.StatisticsOutputColumn;
import com.adbs.querybuilder.StatisticsOutputColumnList;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.olap.sql.QueryTestFrame;

public class QueryPanel
extends JPanel {
    private QueryBuilder queryBuilder = new QueryBuilder();

    public QueryPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.queryBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.queryBuilder.beginUpdate();
        this.queryBuilder.setTabsVisible(false);
        try {
            Icon icon = this.createImageIcon("images/folder.png");
            Icon icon2 = this.createImageIcon("images/table.png");
            Icon icon3 = this.createImageIcon("images/view.png");
            Icon icon4 = this.createImageIcon("images/synonym.png");
            Icon icon5 = this.createImageIcon("images/procedure.png");
            Icon icon6 = this.createImageIcon("images/chart_organisation.png");
            Icon icon7 = this.createImageIcon("images/folder_bullet_green.png");
            Icon icon8 = this.createImageIcon("images/folder_table.png");
            Icon icon9 = this.createImageIcon("images/database_table.png");
            Icon icon10 = this.createImageIcon("images/bullet_green.png");
            QueryStructureTreeOptions queryStructureTreeOptions = this.queryBuilder.getQueryStructureTreeOptions();
            queryStructureTreeOptions.beginUpdate();
            queryStructureTreeOptions.setTreeVisible(false);
            queryStructureTreeOptions.endUpdate();
            MetadataTreeOptions metadataTreeOptions = this.queryBuilder.getMetadataTreeOptions();
            metadataTreeOptions.beginUpdate();
            metadataTreeOptions.setTreeVisible(false);
            metadataTreeOptions.setGroupingType(ObjectsGroupingType.DatabaseSchemaType);
            metadataTreeOptions.setSortingType(ObjectsSortingType.SchemaTypeName);
            metadataTreeOptions.setDatabaseIcon(icon);
            metadataTreeOptions.setSchemaIcon(icon);
            metadataTreeOptions.setTablesNodeIcon(icon);
            metadataTreeOptions.setViewsNodeIcon(icon);
            metadataTreeOptions.setProceduresNodeIcon(icon);
            metadataTreeOptions.setSynonymsNodeIcon(icon);
            metadataTreeOptions.setSystemTablesIcon(icon2);
            metadataTreeOptions.setSystemViewsIcon(icon3);
            metadataTreeOptions.setSystemProceduresIcon(icon5);
            metadataTreeOptions.setSystemSynonymsIcon(icon4);
            metadataTreeOptions.setUserTablesIcon(icon2);
            metadataTreeOptions.setUserViewsIcon(icon3);
            metadataTreeOptions.setUserProceduresIcon(icon5);
            metadataTreeOptions.setUserSynonymsIcon(icon4);
            metadataTreeOptions.setShowSystemTables(false);
            metadataTreeOptions.setShowSystemViews(false);
            metadataTreeOptions.setShowSystemProcedures(false);
            metadataTreeOptions.setShowSystemSynonyms(false);
            metadataTreeOptions.endUpdate();
            AddObjectDialogOptions addObjectDialogOptions = this.queryBuilder.getAddObjectDialogOptions();
            addObjectDialogOptions.beginUpdate();
            addObjectDialogOptions.setTablesIcon(icon2);
            addObjectDialogOptions.setViewsIcon(icon3);
            addObjectDialogOptions.setProceduresIcon(icon5);
            addObjectDialogOptions.setSynonymsIcon(icon4);
            addObjectDialogOptions.endUpdate();
            CriteriaListOptions criteriaListOptions = this.queryBuilder.getCriteriaListOptions();
            criteriaListOptions.setExpressionColumnWidth(200);
        }
        finally {
            this.queryBuilder.endUpdate();
        }
    }

    public Connection getConnection() {
        BaseMetadataProvider baseMetadataProvider = this.queryBuilder.getMetadataProvider();
        if (baseMetadataProvider != null) {
            return baseMetadataProvider.getConnection();
        }
        return null;
    }

    public void loadMetadata(final Connection connection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JdbcMetadataProvider jdbcMetadataProvider = new JdbcMetadataProvider();
                jdbcMetadataProvider.setConnection(connection);
                OracleSyntaxProvider oracleSyntaxProvider = new OracleSyntaxProvider();
                QueryPanel.this.queryBuilder.setSyntaxProvider((BaseSyntaxProvider)oracleSyntaxProvider);
                QueryPanel.this.queryBuilder.setMetadataProvider((BaseMetadataProvider)jdbcMetadataProvider);
                QueryPanel.this.queryBuilder.refreshMetadata();
            }
        });
    }

    public void refreshMetadata() {
        if (this.queryBuilder.getMetadataProvider() != null && this.queryBuilder.getMetadataProvider().isConnected()) {
            this.queryBuilder.refreshMetadata();
        }
    }

    public void clearMetadata() {
        this.queryBuilder.getMetadataContainer().clear();
        this.queryBuilder.clear();
    }

    public String getSQL() {
        return this.queryBuilder.getSQL();
    }

    public void setSQL(String string) {
        this.queryBuilder.setSQL(string);
    }

    public List<String> getProjections() {
        String string = this.queryBuilder.getSQL();
        System.out.println(string);
        QueryStatistics queryStatistics = this.queryBuilder.getQueryStatistics();
        StatisticsOutputColumnList statisticsOutputColumnList = queryStatistics.getOutputColumns();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = statisticsOutputColumnList.getCount();
        for (int i = 0; i < n; ++i) {
            StatisticsOutputColumn statisticsOutputColumn = statisticsOutputColumnList.get(i);
            String string2 = statisticsOutputColumn.getExpression();
            String string3 = statisticsOutputColumn.getExpressionAlias();
            if (string3 != null && string3.length() > 0) {
                string2 = string2 + " " + string3;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getMapQueryExpression() {
        QueryStatistics queryStatistics = this.queryBuilder.getQueryStatistics();
        if (queryStatistics.getUsedDatabaseObjects().getCount() > 0) {
            String string = queryStatistics.getUsedDatabaseObjects().get(0).getFullName().toString();
            return string;
        }
        return "";
    }

    public String getStatistics() {
        int n;
        String string = "";
        QueryStatistics queryStatistics = this.queryBuilder.getQueryStatistics();
        string = "Used Objects (" + queryStatistics.getUsedDatabaseObjects().getCount() + "):\r\n";
        for (n = 0; n < queryStatistics.getUsedDatabaseObjects().getCount(); ++n) {
            string = string + "\r\n" + queryStatistics.getUsedDatabaseObjects().get(n).getFullName().toString();
        }
        string = string + "\r\n\r\nUsed Columns (" + queryStatistics.getUsedDatabaseObjectColumns().getCount() + "): \r\n";
        for (n = 0; n < queryStatistics.getUsedDatabaseObjectColumns().getCount(); ++n) {
            string = string + "\r\n" + queryStatistics.getUsedDatabaseObjectColumns().get(n).getFullName().toString();
        }
        string = string + "\r\n\r\nOutput Expressions (" + queryStatistics.getOutputColumns().getCount() + "): \r\n";
        for (n = 0; n < queryStatistics.getOutputColumns().getCount(); ++n) {
            string = string + "\r\n" + queryStatistics.getOutputColumns().get(n).getExpression();
        }
        string = string + "\r\n\r\n";
        return string;
    }

    protected Icon createImageIcon(String string) {
        URL uRL = QueryTestFrame.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }
}

