/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.RaptorDnDPlugin;
import oracle.dbtools.raptor.controls.query.QueryBuilderEditPanel;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.phighlight.TooltipPlugin;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.task.RunScriptPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.olap.worksheet.editor.OLAPWorksheet;
import oracle.olap.worksheet.editor.OLAPWorksheetTabbedPane;
import oracle.olap.worksheet.editor.UndoCommandWrapper;
import oracle.olap.worksheet.folding.OLAPWorksheetFoldingPlugin;

public class OLAPWorksheetGUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(OLAPWorksheetGUI.class.getName());
    private static final String MARK_CATEGORY = "sqlbookmark";
    private OLAPWorksheet m_worksheet;
    private Toolbar m_toolbar = new Toolbar();
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
    private BasicEditorPane m_editor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
    private EditorStatusBar m_statusBar = new EditorStatusBar();
    private LineGutterPlugin m_sqlGutter = new LineGutterPlugin();
    private FileOverviewMargin m_fileOverviewMargin = new FileOverviewMargin();
    private JSplitPane splitter = null;
    int dividerLocation = 0;
    private OLAPWorksheetTabbedPane m_tabs = new OLAPWorksheetTabbedPane();
    private JPopupMenu m_gutterCtxMenu;
    private GutterListener m_gutterListener = new GutterListener();
    final DocumentListener m_documentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            View.updateToolbarActions((Toolbar)OLAPWorksheetGUI.this.m_toolbar);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }
    };
    private final List<String> m_editSourceCommands = new ArrayList<String>(Arrays.asList("block-indent", "block-outdent", "completion-insight", "toggle-java-comments"));
    private final Controller m_editSourceController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getView() == OLAPWorksheetGUI.this.m_worksheet) {
                String string = ideAction.getCommand();
                if (OLAPWorksheetGUI.this.m_editSourceCommands.contains(string)) {
                    OLAPWorksheetGUI.this.m_editor.invokeAction(string);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (context.getView() == OLAPWorksheetGUI.this.m_worksheet) {
                String string = ideAction.getCommand();
                if (OLAPWorksheetGUI.this.m_editSourceCommands.contains(string)) {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
            return false;
        }
    };
    private Component m_focusComponent;
    private Component m_helpFocusComponent;
    private TextNode m_node;
    private Handler m_handler;
    private FocusHelper m_focusHelper;
    private FocusHelper m_helpFocusHelper;
    private RaptorDnDPlugin m_dnd;
    OLAPWorksheetFoldingPlugin m_foldingPlugin;
    List<RaptorEditorPlugin> m_installedPlugins = new ArrayList<RaptorEditorPlugin>();
    private JPanel m_topPane;
    private CompletionInsight m_insight = null;
    private String _lastConnName;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public OLAPWorksheetGUI(OLAPWorksheet oLAPWorksheet) {
        TextNode textNode;
        Node node;
        this.m_worksheet = oLAPWorksheet;
        TextBuffer textBuffer = null;
        URL uRL = null;
        Context context = oLAPWorksheet.getContext();
        if (context != null) {
            node = context.getNode();
            if (node instanceof TextNode) {
                textNode = (TextNode)node;
                textBuffer = textNode.acquireTextBuffer();
            }
            uRL = node.getURL();
        }
        node = textBuffer != null ? new BasicDocument("foo.olapdml", textBuffer) : new BasicDocument("foo.olapdml");
        this.setLayout(new BorderLayout());
        this.m_editor.setText("");
        this.m_editor.setDocument((Document)node);
        this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.m_dnd = new RaptorDnDPlugin();
        this.m_dnd.setWorksheetConnection(this.m_worksheet.getConnectionName());
        this.m_editor.installPlugin((EditorPlugin)this.m_dnd);
        this.m_editor.installPlugin((EditorPlugin)this.m_statusBar);
        this.m_editor.installPlugin((EditorPlugin)this.m_sqlGutter);
        this.m_editor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.m_foldingPlugin = new OLAPWorksheetFoldingPlugin();
        this.m_editor.installPlugin((EditorPlugin)this.m_foldingPlugin);
        textNode = this.m_foldingPlugin.getCodeFoldingMargin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin(this.m_editor, this.m_worksheet.getConnectionName(), null);
        this.m_foldingPlugin.parser.addParserEventListener((ParserEventListener)highlightEditorPlugin);
        TooltipPlugin tooltipPlugin = new TooltipPlugin();
        this.m_editor.addToolTipProvider(tooltipPlugin.provider);
        this.m_editor.addPropertyChangeListener((PropertyChangeListener)tooltipPlugin);
        tooltipPlugin.addTooltip((TooltipMessage)highlightEditorPlugin);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)textNode, "East");
        jPanel.add((Component)this.m_sqlGutter, "Center");
        this.m_sqlGutter.addGutterClickListener((GutterClickListener)this.m_gutterListener);
        this.createContextMenu();
        this.m_editor.installPlugin((EditorPlugin)this.m_fileOverviewMargin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_editor);
        jScrollPane.setRowHeaderView(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)this.m_fileOverviewMargin, "East");
        this.splitter = new JSplitPane(0);
        this.m_topPane = new JPanel(new CardLayout());
        this.m_topPane.add((Component)jPanel2, WorksheetResources.getString((String)"WORKSHEET_TAB_TITLE"));
        this.addEditorControllers();
        this.splitter.setTopComponent(this.m_topPane);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(0.5);
        this.add((Component)this.splitter, "Center");
        this.m_tabs.setSplitter(this.splitter);
        this.m_editor.getDocument().addDocumentListener(this.m_documentListener);
        this.m_editor.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeDocumentListener(OLAPWorksheetGUI.this.m_documentListener);
                    if (OLAPWorksheetGUI.this.m_handler != null) {
                        document2.removeUndoableEditListener(OLAPWorksheetGUI.this.m_handler);
                    }
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addDocumentListener(OLAPWorksheetGUI.this.m_documentListener);
                    if (OLAPWorksheetGUI.this.m_handler != null) {
                        document.addUndoableEditListener(OLAPWorksheetGUI.this.m_handler);
                    }
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.m_handler == null) {
            this.m_handler = new Handler();
            this.m_editor.addPopupManager((PopupManager)this.m_handler);
            this.m_editor.addKeyListener((KeyListener)this.m_handler);
            Document document = this.m_editor.getDocument();
            document.addUndoableEditListener(this.m_handler);
            this.m_focusHelper = new FocusHelper();
            this.m_helpFocusHelper = new FocusHelper();
            this.m_helpFocusHelper.setIsForHelp();
        }
    }

    OLAPWorksheetTabbedPane getWorksheetTabbedPane() {
        return this.m_tabs;
    }

    private void createContextMenu() {
        if (this.m_gutterCtxMenu == null) {
            final JPopupMenu jPopupMenu = new JPopupMenu("Context Menu");
            JMenuItem jMenuItem = new JMenuItem(WorksheetResources.getString((String)"WORKSHEET_MENU_BOOKMARKS"));
            JMenuItem jMenuItem2 = new JMenuItem(WorksheetResources.getString((String)"WORKSHEET_MENU_LINE_NUMBERS"));
            JPopupMenu jPopupMenu2 = new JPopupMenu(WorksheetResources.getString((String)"WORKSHEET_MENU_GUTTER"));
            jMenuItem.addActionListener(this.m_gutterListener);
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            jPopupMenu2.add(jMenuItem);
            jPopupMenu2.add(jMenuItem2);
            jPopupMenu.add(jPopupMenu2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        jPopupMenu.show((Component)OLAPWorksheetGUI.this.m_sqlGutter, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.m_gutterCtxMenu = jPopupMenu2;
        }
    }

    void dispose() {
        this.m_toolbar.dispose();
        this.m_toolbar.removeAll();
        if (this.m_node != null) {
            this.m_node.releaseTextBuffer();
        }
        this.removeEditorControllers();
        this.m_worksheet = null;
        this.m_foldingPlugin.deinstall(this.m_editor);
        this.m_editor.getDocument().removeDocumentListener(this.m_documentListener);
        this.m_editor = null;
    }

    EditorStatusBar getEdtiorStatusBar() {
        return this.m_statusBar;
    }

    Component getFocusComponent() {
        return this.m_focusComponent;
    }

    Component getHelpFocusComponent() {
        return this.m_helpFocusComponent;
    }

    private Icon getIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    Toolbar getToolbar() {
        return this.m_toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.m_toolbar = toolbar;
    }

    @Override
    public void removeNotify() {
        if (this.m_handler != null) {
            this.m_editor.removePopupManager((PopupManager)this.m_handler);
            this.m_editor.removeKeyListener((KeyListener)this.m_handler);
            this.m_editor.removeMouseListener((MouseListener)this.m_handler);
            Document document = this.m_editor.getDocument();
            document.removeUndoableEditListener(this.m_handler);
            this.m_helpFocusHelper.cleanup();
            this.m_helpFocusHelper = null;
            this.m_helpFocusComponent = null;
            this.m_focusHelper.cleanup();
            this.m_focusHelper = null;
            this.m_handler = null;
        }
        super.removeNotify();
    }

    private void tryContextMenu(MouseEvent mouseEvent) {
        Context context;
        Component component = mouseEvent.getComponent();
        component.requestFocusInWindow();
        if (mouseEvent.isPopupTrigger() && (context = this.m_worksheet.getContext(mouseEvent)) != null) {
            this.m_worksheet.getContextMenu().show(context);
        }
    }

    void updateContext(WorksheetContext worksheetContext) {
        worksheetContext.setEditor(this.m_editor);
        worksheetContext.setCallback((WorksheetCallback)new Callback());
    }

    void addPanel(final WorksheetResultPanel worksheetResultPanel) {
        ITabCloseListner iTabCloseListner = new ITabCloseListner(){

            public void tabClosed() {
                if (OLAPWorksheetGUI.this.m_tabs.getNumberOfTabs() <= 0) {
                    OLAPWorksheetGUI.this.dividerLocation = OLAPWorksheetGUI.this.splitter.getDividerLocation();
                    OLAPWorksheetGUI.this.splitter.remove((Component)((Object)OLAPWorksheetGUI.this.m_tabs));
                    if (OLAPWorksheetGUI.this.m_helpFocusHelper != null) {
                        OLAPWorksheetGUI.this.m_helpFocusHelper.removeFocusListenerRecurse(worksheetResultPanel.getGUI());
                    }
                    OLAPWorksheetGUI.this.m_helpFocusComponent = null;
                }
            }
        };
        ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
        arrayList.add(iTabCloseListner);
        this.m_tabs.addTab(worksheetResultPanel, arrayList);
        if (this.splitter.getBottomComponent() == null) {
            this.splitter.setBottomComponent((Component)((Object)this.m_tabs));
        }
        if (this.dividerLocation != 0) {
            this.splitter.setDividerLocation(this.dividerLocation);
            this.dividerLocation = 0;
        }
        if (worksheetResultPanel != null) {
            if (worksheetResultPanel instanceof RunScriptPanel) {
                ((RunScriptPanel)worksheetResultPanel).getTextPane().addFocusListener((FocusListener)this.m_focusHelper);
            }
            if (this.m_helpFocusHelper != null) {
                this.m_helpFocusHelper.addFocusListenerRecurse(worksheetResultPanel.getGUI());
            }
        }
    }

    WorksheetResultPanel getSelectedResultPanel() {
        return this.m_tabs.getSelectedResultPanel();
    }

    void invokeInsight(String string) {
        this.m_worksheet.getContext();
        if (Connections.getInstance().isOracle(string)) {
            if (this.m_insight != null) {
                this.m_editor.deinstallPlugin((EditorPlugin)this.m_insight);
            }
            this.m_insight = new CompletionInsight(string, (BackgroundParser)this.m_worksheet.getParser());
            this.m_editor.installPlugin((EditorPlugin)this.m_insight);
        }
    }

    public BasicEditorPane getEditorPane() {
        return this.m_editor;
    }

    void updateWorksheetConnection(String string) {
        if (string == null || !string.equals(this._lastConnName)) {
            this._lastConnName = string;
            this.m_dnd.setWorksheetConnection(string);
        }
    }

    private void addEditorControllers() {
        for (String string : this.m_editSourceCommands) {
            IdeAction.find((String)string).addController(this.m_editSourceController);
        }
    }

    private void removeEditorControllers() {
        for (String string : this.m_editSourceCommands) {
            IdeAction.find((String)string).removeController(this.m_editSourceController);
        }
    }

    QueryBuilderEditPanel getQueryBuilderEditPanel() {
        return null;
    }

    static class MarginMark
    implements FileOverviewMark {
        private int m_from;
        private int m_to;
        private String m_tooltip;

        public MarginMark(int n, int n2, String string) {
            this.m_from = n;
            this.m_to = n2;
            this.m_tooltip = string;
        }

        public int getSelectionLength() {
            return this.m_to - this.m_from;
        }

        public int getSelectionStart() {
            return this.m_from;
        }

        public int getSeverity() {
            return 0;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.m_tooltip;
        }
    }

    private class Handler
    implements PopupManager,
    KeyListener,
    MouseListener,
    UndoableEditListener {
        private Handler() {
        }

        public void hidePopup(BasicEditorPane basicEditorPane) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            View.updateToolbarActions((Toolbar)OLAPWorksheetGUI.this.m_toolbar);
            if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown() || !keyEvent.isControlDown() || !keyEvent.isShiftDown() || Character.isDigit(keyEvent.getKeyChar())) {
                // empty if block
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Context context = OLAPWorksheetGUI.this.m_worksheet.getContext(mouseEvent);
            Object object = context.getEvent().getSource();
            if (!object.getClass().toString().equals("oracle.javatools.editor.gutter.LineGutterPlugin")) {
                OLAPWorksheetGUI.this.tryContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            OLAPWorksheetGUI.this.tryContextMenu(mouseEvent);
        }

        public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
            ContextMenu contextMenu = OLAPWorksheetGUI.this.m_worksheet.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show(OLAPWorksheetGUI.this.m_worksheet.getContext(mouseEvent));
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            UndoCommandWrapper undoCommandWrapper = new UndoCommandWrapper(undoableEdit);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            undoCommandWrapper.setContext(OLAPWorksheetGUI.this.m_worksheet.getContext());
            try {
                commandProcessor.invoke((Command)undoCommandWrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class GutterListener
    implements GutterClickListener,
    ActionListener,
    GutterColumnListener {
        private int m_lineNo;
        private List<GutterMark> m_marks;
        private Icon m_bkmkIcon;

        private GutterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GutterMark gutterMark;
            String string = WorksheetResources.getString((String)"WORKSHEET_BOOKMARKS_COLUMN");
            GutterColumn gutterColumn = OLAPWorksheetGUI.this.m_sqlGutter.lookupGutterColumn(string);
            if (gutterColumn == null) {
                gutterColumn = OLAPWorksheetGUI.this.m_sqlGutter.createGutterColumn(string, (GutterColumnListener)this);
            }
            if (this.m_marks == null) {
                this.m_marks = new ArrayList<GutterMark>();
                this.m_bkmkIcon = OLAPWorksheetGUI.this.getIcon("/oracle/dbtools/worksheet/images/bookmark.png");
            }
            boolean bl = false;
            Iterator<GutterMark> iterator = this.m_marks.iterator();
            int n = this.m_lineNo;
            while (iterator.hasNext()) {
                gutterMark = iterator.next();
                if (gutterMark.getLine() != n) continue;
                gutterMark.getGutterColumn().removeGutterMark(gutterMark);
                iterator.remove();
                bl = true;
                break;
            }
            if (!bl) {
                gutterMark = EditorProperties.getProperties();
                HighlightRegistry highlightRegistry = gutterMark.getHighlightRegistry();
                String string2 = WorksheetResources.getString((String)"WORKSHEET_BOOKMARK_STYLE");
                HighlightStyle highlightStyle = highlightRegistry.createStyle(string2, string2, 20, Color.black, new Color(153, 255, 255));
                FileOverviewMargin.setMarkColor((String)OLAPWorksheetGUI.MARK_CATEGORY, (HighlightStyle)highlightStyle);
                this.m_marks.add(gutterColumn.addGutterMark(n, this.m_bkmkIcon, highlightStyle, 1, 1));
                MarginMark marginMark = new MarginMark(n, n, WorksheetResources.getString((String)"WORKSHEET_BOOKMARK_MARK") + n);
                OLAPWorksheetGUI.this.m_fileOverviewMargin.addMark(OLAPWorksheetGUI.MARK_CATEGORY, n, (FileOverviewMark)marginMark);
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            return null;
        }

        public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
            this.m_lineNo = n;
            LineGutterPlugin lineGutterPlugin = (LineGutterPlugin)mouseEvent.getSource();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 8) != 0 || (n2 & 4) != 0) {
                OLAPWorksheetGUI.this.m_gutterCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
            gutterMark.getGutterColumn().removeGutterMark(gutterMark);
            this.m_marks.remove(gutterMark);
        }

        public void markMoved(GutterMark gutterMark, int n, int n2) {
        }

        public void markRemoved(GutterMark gutterMark, int n) {
            int n2 = this.m_marks.indexOf(gutterMark);
            if (n2 != -1) {
                this.m_marks.remove(n2);
            }
        }
    }

    private final class FocusHelper
    implements FocusListener {
        private boolean forHelp = false;

        private FocusHelper() {
            this.addFocusListenerRecurse(OLAPWorksheetGUI.this);
        }

        private void addFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.addFocusListenerRecurse(componentArray[i]);
                }
            }
            component.addFocusListener(this);
        }

        private void cleanup() {
            this.removeFocusListenerRecurse(OLAPWorksheetGUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.forHelp) {
                OLAPWorksheetGUI.this.m_helpFocusComponent = (Component)focusEvent.getSource();
            } else {
                OLAPWorksheetGUI.this.m_focusComponent = (Component)focusEvent.getSource();
            }
        }

        public void setIsForHelp() {
            this.forHelp = true;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        private void removeFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.removeFocusListenerRecurse(componentArray[i]);
                }
            }
            component.removeFocusListener(this);
        }
    }

    private class Callback
    implements WorksheetCallback {
        private WaitCursor m_cursor;

        private Callback() {
        }

        public void setEnabled(boolean bl) {
            if (bl && this.m_cursor != null) {
                this.m_cursor.hide();
                this.m_cursor = null;
            } else if (!bl && this.m_cursor == null) {
                this.m_cursor = new WaitCursor((Component)OLAPWorksheetGUI.this);
                this.m_cursor.show();
            }
        }

        public void showResultPanel(final WorksheetResultPanel worksheetResultPanel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    OLAPWorksheetGUI.this.addPanel(worksheetResultPanel);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void setStatusMessage(String string, Exception exception) {
            AbstractLogPage abstractLogPage = OLAPWorksheetGUI.this.m_worksheet.getLogPage();
            abstractLogPage.logQuietly((Object)(OLAPWorksheetGUI.this.m_worksheet.getTabLabel() + ": " + new Date(System.currentTimeMillis()) + ": " + string + System.getProperty("line.separator")));
            if (exception != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                abstractLogPage.logQuietly((Object)(OLAPWorksheetGUI.this.m_worksheet.getTabLabel() + ": " + new Date(System.currentTimeMillis()) + ": " + exception.getMessage() + System.getProperty("line.separator")));
            }
        }

        public void focusPanel(WorksheetResultPanel worksheetResultPanel) {
            OLAPWorksheetTabbedPane oLAPWorksheetTabbedPane = OLAPWorksheetGUI.this.getWorksheetTabbedPane();
            int n = oLAPWorksheetTabbedPane.getPanelIndex(worksheetResultPanel.getGUI());
            if (n != -1) {
                oLAPWorksheetTabbedPane.setSelectedIndex(n);
            }
        }
    }
}

