/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleDriver;

public class Literals2Binds {
    public static final String prefix = "AUXSQLDBIND";
    private String sql;
    private Map<String, String> binds;

    public String getSql() {
        return this.sql;
    }

    public Map<String, String> getBinds() {
        return this.binds;
    }

    private Literals2Binds(String sql, Map<String, String> binds) {
        this.sql = sql;
        this.binds = binds;
    }

    public static Literals2Binds Literals2BindsNull(String sql) {
        return new Literals2Binds(sql, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Literals2Binds bindAid(String origSql) {
        Object var7_12;
        ArrayList<String> existingBinds = Parser.getInstance().getBindNames(origSql);
        int maxBind = 0;
        for (String eb : existingBinds) {
            try {
                int candidate = Integer.parseInt(eb);
                if (maxBind >= candidate) continue;
                maxBind = candidate;
            }
            catch (NumberFormatException candidate) {}
        }
        List<LexerToken> src = Lexer.parse(origSql);
        String sql = origSql;
        HashMap<String, String> tmp = new HashMap<String, String>();
        try {
            Program.debug = false;
            String recognitionPrg = Service.readFile(Literals2Binds.class, "/oracle/dbtools/app/literals2binds.prg");
            Map<String, MaterializedPredicate> predicateVectors = new SqlProgram(recognitionPrg).run(origSql);
            MaterializedPredicate pragmas = predicateVectors.get("pragmas");
            if (0 < pragmas.cardinality()) {
                Literals2Binds literals2Binds = new Literals2Binds(sql, tmp);
                return literals2Binds;
            }
            MaterializedPredicate symbols = predicateVectors.get("\"procedureCall\"");
            TreeMap<Integer, String> pCall = new TreeMap<Integer, String>();
            for (Tuple tuple : symbols.getTuples()) {
                ParseNode pc = symbols.getAttribute(tuple, "procedureCall");
                LexerToken f = src.get(pc.from);
                LexerToken t_1 = src.get(pc.to - 1);
                pCall.put(f.begin, origSql.substring(f.begin, t_1.end));
            }
            symbols = predicateVectors.get("\"arg\"");
            TreeMap<Integer, String> args = new TreeMap<Integer, String>();
            for (Tuple t : symbols.getTuples()) {
                ParseNode pc = symbols.getAttribute(t, "arg");
                LexerToken f = src.get(pc.from);
                LexerToken t_1 = src.get(pc.to - 1);
                args.put(f.begin, origSql.substring(f.begin, t_1.end));
            }
            int n = maxBind;
            int adjust = 0;
            Iterator iterator = args.keySet().iterator();
            while (iterator.hasNext()) {
                void var12_21;
                int key = (Integer)iterator.next();
                boolean skip = false;
                Iterator iterator2 = pCall.keySet().iterator();
                while (iterator2.hasNext()) {
                    int pKey = (Integer)iterator2.next();
                    String call = ((String)pCall.get(pKey)).toLowerCase();
                    if (pKey >= key || key >= pKey + call.length() || !call.startsWith("dbms_sql") && !call.startsWith("userenv") && !call.startsWith("xmltype") && !call.startsWith("sys_")) continue;
                    skip = true;
                }
                if (skip) continue;
                ++var12_21;
                String literal = (String)args.get(key);
                if (1 < literal.length() && 0 <= literal.substring(1, literal.length() - 1).indexOf(39)) continue;
                boolean isStr = false;
                if (literal.startsWith("'") && literal.endsWith("'")) {
                    isStr = true;
                }
                String bind = "TO_NUMBER(:AUXSQLDBIND" + (int)var12_21 + ")";
                if (isStr) {
                    bind = "TO_CHAR(:AUXSQLDBIND" + (int)var12_21 + ")";
                }
                sql = sql.substring(0, key + adjust) + bind + sql.substring(key + literal.length() + adjust);
                adjust += bind.length() - literal.length();
                if (isStr) {
                    literal = literal.substring(1, literal.length() - 1);
                }
                tmp.put(prefix + (int)var12_21, literal);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            var7_12 = null;
            return var7_12;
        }
        catch (Exception e) {
            e.printStackTrace();
            var7_12 = null;
            return var7_12;
        }
        finally {
            return new Literals2Binds(sql, tmp);
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.sql + "\n");
        for (String bind : this.binds.keySet()) {
            ret.append(bind + "->" + this.binds.get(bind) + "\n");
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String plsqlBlock) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection c = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/xe", "hr", "hr");
        CallableStatement cs = null;
        try {
            cs = c.prepareCall("begin dbms_output.enable(1000000); end;");
            cs.execute();
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        Literals2Binds bp = Literals2Binds.bindAid(plsqlBlock);
        System.out.println(bp.toString());
        cs = c.prepareCall(bp.getSql());
        Map<String, String> bindsMap = bp.getBinds();
        int pos = 1;
        for (String bindName : bindsMap.keySet()) {
            cs.setString(pos++, bindsMap.get(bindName));
        }
        try {
            cs.execute();
            System.out.println("No Exception");
            SQLWarning sw = null;
            for (sw = cs.getWarnings(); sw != null; sw = sw.getNextWarning()) {
                String w = sw.getMessage();
                System.out.println("ZZ: " + w);
            }
            System.out.println("OP: " + Literals2Binds.getDBMSOUTPUT(c));
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBMSOUTPUT(Connection c) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (CallableStatement stmt = null;){
            stmt = c.prepareCall("declare\nl_line varchar2(32767);\nl_done number;\nl_buffer varchar2(32767) := '';\nl_lengthbuffer number := 0;\nl_lengthline number := 0;\nbegin \nloop \n\tdbms_output.get_line( l_line, l_done ); \n\tif (l_buffer is null) then \n\t  l_lengthbuffer := 0; \n\telse \n\t  l_lengthbuffer := length(l_buffer); \n\tend if; \n\tif (l_line is null) then \n\t  l_lengthline := 0; \n\telse \n\t  l_lengthline := length(l_line); \n\tend if; \nexit when l_lengthbuffer + l_lengthline > :maxbytes OR l_lengthbuffer + l_lengthline > 32767 OR l_done = 1; \nl_buffer := l_buffer || l_line || chr(10); \nend loop; \n:done := l_done; \n:buffer := l_buffer; \n:line := l_line; \nend;");
            boolean useLargeBuffer = true;
            if (useLargeBuffer) {
                stmt.registerOutParameter(2, 4);
                stmt.registerOutParameter(3, 12);
                stmt.registerOutParameter(4, 12);
            } else {
                stmt.registerOutParameter(2, 4);
                stmt.registerOutParameter(3, 12);
            }
            do {
                stmt.setInt(1, 1000);
                stmt.executeUpdate();
                if (useLargeBuffer) {
                    String got = stmt.getString(3);
                    if (got != null) {
                        sb.append(got);
                    }
                    if ((got = stmt.getString(4)) != null) {
                        sb.append(got + "\n");
                        continue;
                    }
                    sb.append("\n");
                    continue;
                }
                sb.append(stmt.getString(3));
            } while (stmt.getInt(2) != 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String[] inputs = new String[]{"with   \ntab ( parent, child ) as (   \n  select null, 1 from dual union all   \n  select 1, 2 from dual   \n)   \nselect ltrim(sys_connect_by_path(child, '/'), '/') as path   \nfrom tab   \nstart with parent is null   \nconnect by prior child = parent", "declare \n  x integer; \nbegin \n  select 1 into x from dual where ABS(11)=11; \nend;", "begin dbms_output.put_line('x');dbms_output.put_line('HELLO'||systimestamp); end;", "declare\n   c_xparam constant varchar2(30) := NVL('^XPARAM','');\n   c_test constant varchar2(30) := to_char('^PARAM');\n   c_param_enq constant varchar2(30) := \ndbms_assert.enquote_name('^PARAM',false);\n   c_xyz constant varchar2(30) := NVL('^3', '');\nbegin\n    -- check if param is being displayed in audit log\n    if '^PARAM' is null then\n        raise_application_error(-20203, 'ERROR: Cannot create ORDS_PUBLIC_USER due to missing value for password');\n    end if;\nend;\n\n"};
        inputs = new String[]{Service.readFile("C:/Users/dim/Downloads/ords_create_rest_users_3.sql")};
        for (int i = 0; i < inputs.length; ++i) {
            System.out.println(">>>>>>>>> " + i);
            Literals2Binds.test(inputs[i]);
        }
    }
}

